/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;

public class StaticModifier<T extends Modifier>
extends LazyModifier {
    public StaticModifier(ModifierId id) {
        super(id);
    }

    @Override
    protected Modifier getUnchecked() {
        if (this.result == null) {
            this.result = ModifierManager.INSTANCE.getStatic(this.id);
        }
        return this.result;
    }

    @Override
    public boolean isBound() {
        if (!ModifierManager.INSTANCE.isModifiersRegistered()) {
            return false;
        }
        return this.getUnchecked() != ModifierManager.INSTANCE.getDefaultValue();
    }

    @Override
    public T get() {
        if (!ModifierManager.INSTANCE.isModifiersRegistered()) {
            throw new IllegalStateException("Cannot fetch a static modifiers before modifiers are registered");
        }
        Modifier result = this.getUnchecked();
        if (result == ModifierManager.INSTANCE.getDefaultValue()) {
            throw new IllegalStateException("Static modifier for " + String.valueOf((Object)this.id) + " returned " + String.valueOf((Object)ModifierManager.EMPTY) + ", this typically indicates the modifier is improperly registered");
        }
        return (T)result;
    }

    @Override
    public String toString() {
        return "StaticModifier{" + String.valueOf((Object)this.id) + "}";
    }
}

