/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.worktable;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6862;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.modifier.TagModifierPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierSetWorktableRecipe
extends AbstractWorktableRecipe {
    private static final class_2561 NO_MATCHES = TConstruct.makeTranslation("recipe", "modifier_set_worktable.empty");
    private static final BiFunction<class_2487, String, class_2499> LIST_GETTER = (tag, name) -> tag.method_10554(name, 8);
    private final class_2561 title;
    private final class_2561 description;
    private final class_2960 dataKey;
    private final IJsonPredicate<ModifierId> modifierPredicate;
    private final Predicate<ModifierEntry> entryFilter;
    private final boolean addToSet;
    private final boolean allowTraits;
    private List<ModifierEntry> filteredModifiers = null;

    public ModifierSetWorktableRecipe(class_2960 id, class_2960 dataKey, List<SizedIngredient> inputs, class_1856 toolRequirement, IJsonPredicate<ModifierId> modifierPredicate, boolean addToSet, boolean allowTraits) {
        super(id, toolRequirement, inputs);
        this.dataKey = dataKey;
        this.addToSet = addToSet;
        String rootKey = Util.makeTranslationKey("recipe", dataKey) + (addToSet ? ".adding" : ".removing");
        this.title = class_2561.method_43471((String)(rootKey + ".title"));
        this.description = class_2561.method_43471((String)(rootKey + ".description"));
        this.modifierPredicate = modifierPredicate;
        this.entryFilter = entry -> modifierPredicate.matches((Object)entry.getId());
        this.allowTraits = allowTraits;
    }

    @Deprecated
    public ModifierSetWorktableRecipe(class_2960 id, class_2960 dataKey, List<SizedIngredient> inputs, IJsonPredicate<ModifierId> modifierPredicate, boolean addToSet) {
        this(id, dataKey, inputs, class_1856.method_8106(TinkerTags.Items.MODIFIABLE), modifierPredicate, addToSet, false);
    }

    @Deprecated
    public ModifierSetWorktableRecipe(class_2960 id, class_2960 dataKey, List<SizedIngredient> inputs, class_6862<Modifier> blacklist, boolean addToSet) {
        this(id, dataKey, inputs, new TagModifierPredicate(blacklist).inverted(), addToSet);
    }

    private List<ModifierEntry> getModifiers(ITinkerableContainer inv) {
        if (this.allowTraits) {
            return inv.getTinkerable().getModifiers().getModifiers();
        }
        return inv.getTinkerable().getUpgrades().getModifiers();
    }

    @Override
    public class_2561 getDescription(@Nullable ITinkerableContainer inv) {
        if (inv != null && this.getModifiers(inv).stream().noneMatch(this.entryFilter)) {
            return NO_MATCHES;
        }
        return this.description;
    }

    @Override
    public List<ModifierEntry> getModifierOptions(@Nullable ITinkerableContainer inv) {
        if (inv == null) {
            if (this.filteredModifiers == null) {
                this.filteredModifiers = ModifierRecipeLookup.getRecipeModifierList().stream().filter(this.entryFilter).toList();
            }
            return this.filteredModifiers;
        }
        ToolStack tool = inv.getTinkerable();
        Set<ModifierId> existing = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), this.dataKey);
        Predicate<ModifierEntry> applicable = entry -> existing.contains((Object)entry.getId()) != this.addToSet;
        return this.getModifiers(inv).stream().filter(this.entryFilter).filter(applicable).toList();
    }

    @Override
    public RecipeResult<ToolStack> getResult(ITinkerableContainer inv, ModifierEntry modifier) {
        class_2499 tagList;
        ToolStack tool = inv.getTinkerable().copy();
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(this.dataKey, 9)) {
            tagList = persistentData.get(this.dataKey, LIST_GETTER);
        } else {
            tagList = new class_2499();
            persistentData.put(this.dataKey, (class_2520)tagList);
        }
        String value = modifier.getId().toString();
        boolean found = false;
        for (int i = 0; i < tagList.size(); ++i) {
            if (!tagList.method_10608(i).equals(value)) continue;
            if (!this.addToSet) {
                tagList.method_10536(i);
            }
            found = true;
            break;
        }
        if (!found && this.addToSet) {
            tagList.add((Object)class_2519.method_23256((String)value));
        }
        return RecipeResult.success(tool);
    }

    public class_1865<?> method_8119() {
        return (class_1865)TinkerModifiers.modifierSetWorktableSerializer.get();
    }

    public static Set<ModifierId> getModifierSet(IModDataView modData, class_2960 key) {
        return modData.get(key, LIST_GETTER).stream().map(tag -> ModifierId.tryParse(tag.method_10714())).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static boolean isInSet(IModDataView modData, class_2960 key, ModifierId modifier) {
        if (!modData.contains(key, 9)) {
            return false;
        }
        String modifierStr = modifier.toString();
        for (class_2520 tag : modData.get(key, LIST_GETTER)) {
            if (!modifierStr.equals(tag.method_10714())) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<ModifierSetWorktableRecipe> {
        public ModifierSetWorktableRecipe fromJson(class_2960 id, JsonObject json) {
            class_2960 dataKey = JsonHelper.getResourceLocation((JsonObject)json, (String)"data_key");
            class_1856 tool = class_1856.method_52177((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"tools"));
            List ingredients = JsonHelper.parseList((JsonObject)json, (String)"inputs", SizedIngredient::deserialize);
            IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.ALWAYS;
            if (json.has("modifier_predicate")) {
                modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.getAndDeserialize(json, "modifier_predicate");
            } else if (json.has("blacklist")) {
                modifierPredicate = new TagModifierPredicate(ModifierManager.getTag(JsonHelper.getResourceLocation((JsonObject)json, (String)"blacklist"))).inverted();
                TConstruct.LOG.info("Recipe " + String.valueOf(id) + " is using deprecated blacklist key, this will be removed in 1.19");
            }
            boolean addToSet = class_3518.method_15270((JsonObject)json, (String)"add_to_set");
            boolean allowTraits = class_3518.method_15258((JsonObject)json, (String)"allow_traits", (boolean)false);
            return new ModifierSetWorktableRecipe(id, dataKey, ingredients, tool, modifierPredicate, addToSet, allowTraits);
        }

        @Nullable
        protected ModifierSetWorktableRecipe fromNetworkSafe(class_2960 id, class_2540 buffer) {
            class_2960 dataKey = buffer.method_10810();
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            int size = buffer.method_10816();
            ImmutableList.Builder ingredients = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                ingredients.add((Object)SizedIngredient.read((class_2540)buffer));
            }
            IJsonPredicate modifierPredicate = (IJsonPredicate)ModifierPredicate.LOADER.fromNetwork(buffer);
            boolean addToSet = buffer.readBoolean();
            boolean allowTraits = buffer.readBoolean();
            return new ModifierSetWorktableRecipe(id, dataKey, (List<SizedIngredient>)ingredients.build(), ingredient, (IJsonPredicate<ModifierId>)modifierPredicate, addToSet, allowTraits);
        }

        protected void toNetworkSafe(class_2540 buffer, ModifierSetWorktableRecipe recipe) {
            buffer.method_10812(recipe.dataKey);
            recipe.toolRequirement.method_8088(buffer);
            buffer.method_10804(recipe.inputs.size());
            for (SizedIngredient ingredient : recipe.inputs) {
                ingredient.write(buffer);
            }
            ModifierPredicate.LOADER.toNetwork(recipe.modifierPredicate, buffer);
            buffer.writeBoolean(recipe.addToSet);
            buffer.writeBoolean(recipe.allowTraits);
        }
    }
}

