/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.fabricators_of_create.porting_lib.common.util.Lazy;
import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import io.github.fabricators_of_create.porting_lib.item.CustomMaxCountItem;
import io.github.fabricators_of_create.porting_lib.item.DamageableItem;
import io.github.fabricators_of_create.porting_lib.item.ReequipAnimationItem;
import io.github.fabricators_of_create.porting_lib.item.ShieldBlockItem;
import io.github.fabricators_of_create.porting_lib.item.api.extensions.RepairableItem;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import io.github.fabricators_of_create.porting_lib.tool.addons.ToolActionItem;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemItemStorages;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifiableItemUtil;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerToolActions;

public abstract class ModifiableLauncherItem
extends class_1811
implements IModifiableDisplay,
CustomEnchantingBehaviorItem,
DamageableItem,
CustomMaxCountItem,
ShieldBlockItem,
ToolActionItem,
RepairableItem,
ReequipAnimationItem {
    public static final TinkerDataCapability.TinkerDataKey<Float> DRAWSPEED = TConstruct.createKey("drawspeed");
    public static final class_2960 KEY_DRAWTIME = TConstruct.getResource("drawtime");
    private final ToolDefinition toolDefinition;
    private class_1799 toolForRendering;

    public ModifiableLauncherItem(class_1792.class_1793 properties, ToolDefinition toolDefinition, class_5321<class_1761> tab) {
        super(properties);
        this.toolDefinition = toolDefinition;
        ((FabricItemSettings)properties).customDamage(this::damageItem);
        ItemGroupEvents.modifyEntriesEvent(tab).register(this::fillItemCategory);
        FluidStorage.ITEM.registerForItems((itemStack, context) -> new ToolFluidCapability((ContainerItemContext)context, (Supplier<? extends IToolStackView>)Lazy.of(() -> ToolStack.from(itemStack))), new class_1935[]{this});
        ItemItemStorages.ITEM.registerForItems((itemStack, context) -> ToolInventoryCapability.getCap(context, itemStack), new class_1935[]{this});
    }

    public int getItemStackLimit(class_1799 stack) {
        return 1;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean isBookEnchantable(class_1799 stack, class_1799 book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        return enchantment.method_8195() && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int method_7837() {
        return 0;
    }

    public void method_7860(class_2487 nbt) {
        ToolStack.verifyTag((class_1792)this, nbt, this.getToolDefinition());
    }

    public void method_7843(class_1799 stack, class_1937 worldIn, class_1657 playerIn) {
        ToolStack.ensureInitialized(stack, this.getToolDefinition());
    }

    public boolean method_7886(class_1799 stack) {
        return ModifierUtil.checkVolatileFlag(stack, SHINY);
    }

    public class_1814 method_7862(class_1799 stack) {
        int rarity = ModifierUtil.getVolatileInt(stack, RARITY);
        return class_1814.values()[class_3532.method_15340((int)rarity, (int)0, (int)3)];
    }

    public boolean hasCustomEntity(class_1799 stack) {
        return IndestructibleItemEntity.hasCustomEntity(stack);
    }

    public class_1297 createEntity(class_1937 world, class_1297 original, class_1799 stack) {
        return IndestructibleItemEntity.createFrom(world, original, stack);
    }

    public boolean isRepairable(class_1799 stack) {
        return false;
    }

    public boolean method_7846() {
        return true;
    }

    public int getMaxDamage(class_1799 stack) {
        if (!this.method_7846()) {
            return 0;
        }
        ToolStack tool = ToolStack.from(stack);
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        return tool.isBroken() ? durability + 1 : durability;
    }

    public int getDamage(class_1799 stack) {
        if (!this.method_7846()) {
            return 0;
        }
        return ToolStack.from(stack).getDamage();
    }

    public void setDamage(class_1799 stack, int damage) {
        if (this.method_7846()) {
            ToolStack.from(stack).setDamage(damage);
        }
    }

    public <T extends class_1309> int damageItem(class_1799 stack, int amount, T damager, Consumer<T> onBroken) {
        ToolDamageUtil.handleDamageItem(stack, amount, damager, onBroken);
        return 0;
    }

    public boolean method_31567(class_1799 pStack) {
        return ToolDamageUtil.showDurabilityBar(pStack);
    }

    public int method_31571(class_1799 pStack) {
        return ToolDamageUtil.getRGBDurabilityForDisplay(pStack);
    }

    public int method_31569(class_1799 pStack) {
        return ToolDamageUtil.getDamageForDisplay(pStack);
    }

    public void method_7888(class_1799 stack, class_1937 worldIn, class_1297 entityIn, int itemSlot, boolean isSelected) {
        ModifiableItemUtil.heldInventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean onLeftClickEntity(class_1799 stack, class_1657 player, class_1297 target) {
        return EntityInteractionModifierHook.leftClickEntity(stack, player, target);
    }

    public boolean canPerformAction(class_1799 stack, ToolAction toolAction) {
        return ModifierUtil.canPerformAction(ToolStack.from(stack), toolAction);
    }

    @Override
    public Multimap<class_1320, class_1322> getAttributeModifiers(IToolStackView tool, class_1304 slot) {
        return ModifiableItemUtil.getMeleeAttributeModifiers(tool, slot);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || slot.method_5925() != class_1304.class_1305.field_6177) {
            return ImmutableMultimap.of();
        }
        return this.getAttributeModifiers(ToolStack.from(stack), slot);
    }

    public boolean canDisableShield(class_1799 stack, class_1799 shield, class_1309 entity, class_1309 attacker) {
        return !ToolDamageUtil.isBroken(stack) && this.toolDefinition.getData().canPerformAction(TinkerToolActions.SHIELD_DISABLE);
    }

    public int method_7881(class_1799 pStack) {
        return 72000;
    }

    public abstract class_1839 method_7853(class_1799 var1);

    public class_2561 method_7864(class_1799 stack) {
        return TooltipUtil.getDisplayName(stack, this.getToolDefinition());
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        TooltipUtil.addInformation((IModifiableDisplay)this, stack, level, tooltip, SafeClientAccess.getTooltipKey(), flag);
    }

    public int getDefaultTooltipHideFlags(class_1799 stack) {
        return TooltipUtil.getModifierHideFlags(this.getToolDefinition());
    }

    public void fillItemCategory(FabricItemGroupEntries items) {
        ToolBuildHandler.addDefaultSubItems(this, items, new MaterialVariantId[0]);
    }

    @Override
    public class_1799 getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering((class_1792)this, this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return !this.shouldCauseReequipAnimation(oldStack, newStack, false);
    }

    public boolean shouldCauseReequipAnimation(class_1799 oldStack, class_1799 newStack, boolean slotChanged) {
        return ModifiableItemUtil.shouldCauseReequip(oldStack, newStack, slotChanged);
    }

    public boolean isSuitableFor(class_1799 stack, class_2680 state) {
        return ToolHarvestLogic.isEffective(ToolStack.from(stack), state);
    }

    public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 state, class_2338 pos, class_1309 entityLiving) {
        return ToolHarvestLogic.mineBlock(stack, worldIn, state, pos, entityLiving);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        return ToolHarvestLogic.getDestroySpeed(stack, state);
    }

    public boolean onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
        return ToolHarvestLogic.handleBlockBreak(stack, pos, player);
    }

    protected static float getAngleStart(int count) {
        return -5 * (count - 1);
    }

    @Override
    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }
}

