/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public class MaterialIdNBT {
    static final MaterialIdNBT EMPTY = new MaterialIdNBT((List<? extends MaterialVariantId>)ImmutableList.of());
    private final List<MaterialVariantId> materials;

    public MaterialIdNBT(List<? extends MaterialVariantId> materials) {
        this.materials = ImmutableList.copyOf(materials);
    }

    public MaterialVariantId getMaterial(int index) {
        if (index >= this.materials.size() || index < 0) {
            return IMaterial.UNKNOWN_ID;
        }
        return this.materials.get(index);
    }

    public MaterialIdNBT resolveRedirects() {
        boolean changed = false;
        ImmutableList.Builder builder = ImmutableList.builder();
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        for (MaterialVariantId id : this.materials) {
            MaterialId original = id.getId();
            MaterialId resolved = registry.resolve(original);
            if (resolved != original) {
                changed = true;
            }
            builder.add((Object)MaterialVariantId.create(resolved, id.getVariant()));
        }
        if (changed) {
            return new MaterialIdNBT((List<? extends MaterialVariantId>)builder.build());
        }
        return this;
    }

    public static MaterialIdNBT readFromNBT(@Nullable class_2520 nbt) {
        if (nbt == null || nbt.method_10711() != 9) {
            return EMPTY;
        }
        class_2499 listNBT = (class_2499)nbt;
        if (listNBT.method_10601() != 8) {
            return EMPTY;
        }
        List materials = listNBT.stream().map(class_2520::method_10714).map(MaterialVariantId::tryParse).filter(Objects::nonNull).collect(Collectors.toList());
        return new MaterialIdNBT(materials);
    }

    public class_2499 serializeToNBT() {
        return this.materials.stream().map(Object::toString).map(class_2519::method_23256).collect(Collectors.toCollection(class_2499::new));
    }

    public static MaterialIdNBT from(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null) {
            return MaterialIdNBT.readFromNBT((class_2520)nbt.method_10554("tic_materials", 8));
        }
        return EMPTY;
    }

    public class_1799 updateStack(class_1799 stack) {
        stack.method_7948().method_10566("tic_materials", (class_2520)this.serializeToNBT());
        return stack;
    }

    public class_2487 updateNBT(class_2487 nbt) {
        nbt.method_10566("tic_materials", (class_2520)this.serializeToNBT());
        return nbt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialIdNBT)) {
            return false;
        }
        MaterialIdNBT other = (MaterialIdNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MaterialVariantId> this$materials = this.getMaterials();
        List<MaterialVariantId> other$materials = other.getMaterials();
        return !(this$materials == null ? other$materials != null : !((Object)this$materials).equals(other$materials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialIdNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MaterialVariantId> $materials = this.getMaterials();
        result = result * 59 + ($materials == null ? 43 : ((Object)$materials).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialIdNBT(materials=" + String.valueOf(this.getMaterials()) + ")";
    }

    public List<MaterialVariantId> getMaterials() {
        return this.materials;
    }
}

