/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class MultiplierNBT {
    public static Serializer SERIALIZER = new Serializer();
    public static final MultiplierNBT EMPTY = new MultiplierNBT((Map<INumericToolStat<?>, Float>)ImmutableMap.of());
    private final Map<INumericToolStat<?>, Float> stats;

    public static Builder builder() {
        return new Builder();
    }

    public Set<INumericToolStat<?>> getContainedStats() {
        return this.stats.keySet();
    }

    public boolean hasStat(INumericToolStat<?> stat) {
        return this.stats.containsKey(stat);
    }

    public float get(INumericToolStat<?> stat) {
        return this.stats.getOrDefault(stat, Float.valueOf(1.0f)).floatValue();
    }

    public static MultiplierNBT readFromNBT(@Nullable class_2520 inbt) {
        if (inbt == null || inbt.method_10711() != 10) {
            return EMPTY;
        }
        Builder builder = MultiplierNBT.builder();
        class_2487 nbt = (class_2487)inbt;
        for (String key : nbt.method_10541()) {
            IToolStat<?> iToolStat;
            if (!nbt.method_10573(key, 99) || !((iToolStat = StatsNBT.readStatIdFromNBT(key)) instanceof INumericToolStat)) continue;
            INumericToolStat stat = (INumericToolStat)iToolStat;
            builder.set(stat, nbt.method_10583(key));
        }
        return builder.build();
    }

    public class_2487 serializeToNBT() {
        class_2487 nbt = new class_2487();
        for (Map.Entry<INumericToolStat<?>, Float> entry : this.stats.entrySet()) {
            nbt.method_10548(entry.getKey().getName().toString(), entry.getValue().floatValue());
        }
        return nbt;
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10804(this.stats.size());
        for (Map.Entry<INumericToolStat<?>, Float> entry : this.stats.entrySet()) {
            buffer.method_10814(entry.getKey().getName().toString());
            buffer.writeFloat(entry.getValue().floatValue());
        }
    }

    public static MultiplierNBT fromNetwork(class_2540 buffer) {
        Builder builder = MultiplierNBT.builder();
        int max = buffer.method_10816();
        for (int i = 0; i < max; ++i) {
            IToolStat<?> stat = ToolStats.fromNetwork(buffer);
            float value = buffer.readFloat();
            if (!(stat instanceof INumericToolStat)) continue;
            INumericToolStat numericStat = (INumericToolStat)stat;
            builder.set(numericStat, value);
        }
        return builder.build();
    }

    MultiplierNBT(Map<INumericToolStat<?>, Float> stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiplierNBT)) {
            return false;
        }
        MultiplierNBT other = (MultiplierNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<INumericToolStat<?>, Float> this$stats = this.stats;
        Map<INumericToolStat<?>, Float> other$stats = other.stats;
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiplierNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<INumericToolStat<?>, Float> $stats = this.stats;
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    public String toString() {
        return "MultiplierNBT(stats=" + String.valueOf(this.stats) + ")";
    }

    public static class Builder {
        private final ImmutableMap.Builder<INumericToolStat<?>, Float> builder = ImmutableMap.builder();

        public Builder set(INumericToolStat<?> stat, float value) {
            if (value != 1.0f) {
                this.builder.put(stat, (Object)Float.valueOf(Math.max(value, 0.0f)));
            }
            return this;
        }

        public MultiplierNBT build() {
            ImmutableMap map = this.builder.build();
            if (map.isEmpty()) {
                return EMPTY;
            }
            return new MultiplierNBT((Map<INumericToolStat<?>, Float>)map);
        }

        private Builder() {
        }
    }

    protected static class Serializer
    implements JsonDeserializer<MultiplierNBT>,
    JsonSerializer<MultiplierNBT> {
        protected Serializer() {
        }

        public MultiplierNBT deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = class_3518.method_15295((JsonElement)json, (String)"stats");
            Builder builder = MultiplierNBT.builder();
            for (Map.Entry entry : object.entrySet()) {
                String key = (String)entry.getKey();
                builder.set(ToolStats.numericFromJson(key), class_3518.method_15269((JsonElement)((JsonElement)entry.getValue()), (String)key));
            }
            return builder.build();
        }

        public JsonElement serialize(MultiplierNBT stats, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry<INumericToolStat<?>, Float> entry : stats.stats.entrySet()) {
                json.addProperty(entry.getKey().getName().toString(), (Number)entry.getValue());
            }
            return json;
        }
    }
}

