/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.common.util.Lazy;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3611;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;

public class MeltingFuelHandler {
    private static List<Pair<Integer, List<FluidStack>>> fuelLookup = Collections.emptyList();
    private static Map<class_3611, Integer> temperatureLookup = Collections.emptyMap();
    public static final Lazy<List<class_1799>> SOLID_FUELS = Lazy.of(() -> Arrays.asList(new class_1799((class_1935)class_1802.field_8713), new class_1799((class_1935)class_1802.field_8665), new class_1799((class_1935)class_2246.field_10431), new class_1799((class_1935)class_2246.field_10161), new class_1799((class_1935)class_1802.field_8894)));

    public static void setMeltngFuels(List<MeltingFuel> fuels) {
        fuels.sort(Comparator.comparingInt(MeltingFuel::getTemperature));
        fuelLookup = fuels.stream().mapToInt(MeltingFuel::getTemperature).distinct().mapToObj(temperature -> Pair.of((Object)temperature, fuels.stream().filter(fuel -> fuel.getTemperature() >= temperature).flatMap(fuel -> fuel.getInputs().stream()).collect(Collectors.toList()))).collect(Collectors.toList());
        temperatureLookup = fuels.stream().collect(HashMap::new, (map, fuel) -> {
            int temperature = fuel.getTemperature();
            fuel.getInputs().forEach(fluid -> map.put(fluid.getFluid(), temperature));
        }, Map::putAll);
    }

    public static List<FluidStack> getUsableFuels(int temperature) {
        for (Pair<Integer, List<FluidStack>> pair : fuelLookup) {
            if (temperature > (Integer)pair.getFirst()) continue;
            return (List)pair.getSecond();
        }
        return Collections.emptyList();
    }

    public static OptionalInt getTemperature(class_3611 fluid) {
        Integer temperature = temperatureLookup.get(fluid);
        if (temperature != null) {
            return OptionalInt.of(temperature);
        }
        return OptionalInt.empty();
    }
}

