/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import java.util.Collections;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.MixerAlloyTank;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.SingleAlloyingModule;
import slimeknights.tconstruct.smeltery.menu.AlloyerContainerMenu;

public class AlloyerBlockEntity
extends NameableBlockEntity
implements ITankBlockEntity,
SidedStorageBlockEntity {
    private static final long TANK_CAPACITY = SearedTankBlock.TankType.INGOT_TANK.getCapacity();
    private static final class_2561 NAME = TConstruct.makeTranslation("gui", "alloyer");
    public static final class_5558<AlloyerBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.tick(level, pos, state);
    protected final FluidTankAnimated tank = new FluidTankAnimated(TANK_CAPACITY, (MantleBlockEntity)this);
    private final MixerAlloyTank alloyTank = new MixerAlloyTank((MantleBlockEntity)this, (SlottedStorage<FluidVariant>)this.tank);
    private final SingleAlloyingModule alloyingModule = new SingleAlloyingModule((MantleBlockEntity)this, this.alloyTank);
    private final FuelModule fuelModule = new FuelModule((MantleBlockEntity)this, () -> Collections.singletonList(this.field_11867.method_10074()));
    private int lastStrength = -1;
    private int tick;

    public AlloyerBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)TinkerSmeltery.alloyer.get(), pos, state);
    }

    protected AlloyerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, NAME);
    }

    @Nonnull
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 direction) {
        return this.tank;
    }

    private boolean isFormed() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)MelterBlock.IN_STRUCTURE) && (Boolean)state.method_11654((class_2769)MelterBlock.IN_STRUCTURE) != false;
    }

    private void tick(class_1937 level, class_2338 pos, class_2680 state) {
        if (!this.isFormed()) {
            return;
        }
        switch (this.tick) {
            case 0: {
                this.alloyTank.setTemperature(this.fuelModule.findFuel(false));
                if (this.fuelModule.hasFuel() || !this.alloyingModule.canAlloy()) break;
                this.fuelModule.findFuel(true);
                break;
            }
            case 2: {
                boolean hasFuel = this.fuelModule.hasFuel();
                if ((Boolean)state.method_11654((class_2769)ControllerBlock.ACTIVE) != hasFuel) {
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    class_2338 down = pos.method_10074();
                    class_2680 downState = level.method_8320(down);
                    if (downState.method_26164(TinkerTags.Blocks.FUEL_TANKS) && downState.method_28498((class_2769)ControllerBlock.ACTIVE) && (Boolean)downState.method_11654((class_2769)ControllerBlock.ACTIVE) != hasFuel) {
                        level.method_8501(down, (class_2680)downState.method_11657((class_2769)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                }
                if (!hasFuel) break;
                this.alloyTank.setTemperature(this.fuelModule.getTemperature());
                this.alloyingModule.doAlloy();
                this.fuelModule.decreaseFuel(1);
            }
        }
        this.tick = (this.tick + 1) % 4;
    }

    public void neighborChanged(class_2350 side) {
        this.alloyTank.refresh(side, true);
    }

    @javax.annotation.Nullable
    public class_1703 createMenu(int id, class_1661 inv, class_1657 playerEntity) {
        return new AlloyerContainerMenu(id, inv, this);
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void saveSynced(class_2487 tag) {
        super.saveSynced(tag);
        tag.method_10566("tank", (class_2520)this.tank.writeToNBT(new class_2487()));
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.fuelModule.writeToTag(tag);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.tank.readFromNBT(nbt.method_10562("tank"));
        this.fuelModule.readFromTag(nbt);
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    public MixerAlloyTank getAlloyTank() {
        return this.alloyTank;
    }

    public FuelModule getFuelModule() {
        return this.fuelModule;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }
}

