/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.inventory;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import slimeknights.tconstruct.smeltery.block.entity.inventory.DuctItemHandler;

public class DuctTankWrapper
implements SlottedStorage<FluidVariant> {
    private final SlottedStorage<FluidVariant> parent;
    private final DuctItemHandler itemHandler;

    public int getSlotCount() {
        return this.parent.getSlotCount();
    }

    public SingleSlotStorage<FluidVariant> getSlot(int tank) {
        return this.parent.getSlot(tank);
    }

    public Iterator<StorageView<FluidVariant>> iterator() {
        return Iterators.transform((Iterator)this.parent.iterator(), x$0 -> new FilteringStorageView((StorageView<FluidVariant>)x$0));
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (maxAmount <= 0L || resource.isBlank() || !this.itemHandler.getFluid().isFluidEqual(resource)) {
            return 0L;
        }
        return this.parent.insert((Object)resource, maxAmount, transaction);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        if (maxAmount <= 0L || resource.isBlank() || !this.itemHandler.getFluid().isFluidEqual(resource)) {
            return 0L;
        }
        return this.parent.extract((Object)resource, maxAmount, transaction);
    }

    public DuctTankWrapper(SlottedStorage<FluidVariant> parent, DuctItemHandler itemHandler) {
        this.parent = parent;
        this.itemHandler = itemHandler;
    }

    private class FilteringStorageView
    implements StorageView<FluidVariant> {
        private final StorageView<FluidVariant> backingView;

        private FilteringStorageView(StorageView<FluidVariant> backingView) {
            this.backingView = backingView;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (maxAmount <= 0L || resource.isBlank() || !DuctTankWrapper.this.itemHandler.getFluid().isFluidEqual(resource)) {
                return 0L;
            }
            return this.backingView.extract((Object)resource, maxAmount, transaction);
        }

        public boolean isResourceBlank() {
            return this.backingView.isResourceBlank();
        }

        public FluidVariant getResource() {
            return (FluidVariant)this.backingView.getResource();
        }

        public long getAmount() {
            return this.backingView.getAmount();
        }

        public long getCapacity() {
            return this.backingView.getCapacity();
        }

        public StorageView<FluidVariant> getUnderlyingView() {
            return this.backingView.getUnderlyingView();
        }
    }
}

