/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import slimeknights.tconstruct.smeltery.block.entity.CastingBlockEntity;

public class CastingFluidHandler
extends SnapshotParticipant<Snapshot>
implements SingleSlotStorage<FluidVariant> {
    private final CastingBlockEntity tile;
    private FluidStack fluid = FluidStack.EMPTY;
    private long capacity = 0L;
    private class_3611 filter = class_3612.field_15906;
    private static final String TAG_FLUID = "fluid";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_CAPACITY = "capacity";

    public boolean isFluidValid(FluidStack stack) {
        return !stack.isEmpty() && (this.filter == class_3612.field_15906 || stack.getFluid() == this.filter);
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public long getCapacity() {
        if (this.capacity == 0L) {
            return this.fluid.getAmount();
        }
        return this.capacity;
    }

    public void reset() {
        this.capacity = 0L;
        this.fluid = FluidStack.EMPTY;
        this.filter = class_3612.field_15906;
    }

    public long insert(FluidVariant variant, long maxAmount, TransactionContext tx) {
        FluidStack resource = new FluidStack(variant, maxAmount);
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0L;
        }
        long capacity = this.capacity;
        if (this.filter == null || this.capacity == 0L) {
            class_3611 fluid = variant.getFluid();
            capacity = this.tile.initNewCasting(resource, tx);
            if (capacity <= 0L) {
                return 0L;
            }
            this.updateSnapshots(tx);
            this.capacity = capacity;
            this.filter = fluid;
        }
        if (this.fluid.isEmpty()) {
            long amount = Math.min(capacity, maxAmount);
            this.updateSnapshots(tx);
            this.fluid = new FluidStack(resource, amount);
            tx.addOuterCloseCallback(result -> {
                if (result.wasCommitted()) {
                    this.tile.onContentsChanged();
                }
            });
            return amount;
        }
        if (!FluidStack.isFluidEqual((FluidVariant)variant, (FluidVariant)this.fluid.getType())) {
            return 0L;
        }
        long space = capacity - this.fluid.getAmount();
        if (space <= 0L) {
            return 0L;
        }
        long amount = resource.getAmount();
        if (amount < space) {
            this.updateSnapshots(tx);
            this.fluid.grow(amount);
            tx.addOuterCloseCallback(result -> {
                if (result.wasCommitted()) {
                    this.tile.onContentsChanged();
                }
            });
            return amount;
        }
        this.updateSnapshots(tx);
        this.fluid.setAmount(capacity);
        tx.addOuterCloseCallback(result -> {
            if (result.wasCommitted()) {
                this.tile.onContentsChanged();
            }
        });
        return space;
    }

    public long extract(FluidVariant resource, long maxDrain, TransactionContext tx) {
        if (maxDrain <= 0L || resource.isBlank() || !FluidStack.isFluidEqual((FluidVariant)resource, (FluidVariant)this.fluid.getType())) {
            return 0L;
        }
        long drained = Math.min(this.fluid.getAmount(), maxDrain);
        if (drained <= 0L) {
            return 0L;
        }
        this.updateSnapshots(tx);
        this.fluid.shrink(drained);
        tx.addOuterCloseCallback(result -> {
            if (result.wasCommitted()) {
                if (this.fluid.isEmpty()) {
                    this.tile.reset();
                } else {
                    this.tile.onContentsChanged();
                }
            }
        });
        return drained;
    }

    public boolean isResourceBlank() {
        return this.fluid.getType().isBlank();
    }

    public FluidVariant getResource() {
        return this.fluid.getType();
    }

    public long getAmount() {
        return this.fluid.getAmount();
    }

    protected Snapshot createSnapshot() {
        return new Snapshot(this.capacity, this.fluid.copy(), this.filter);
    }

    protected void readSnapshot(Snapshot snapshot) {
        this.capacity = snapshot.capacity;
        this.fluid = snapshot.fluidStack;
        this.filter = snapshot.filter;
    }

    public void readFromTag(class_2487 nbt) {
        class_3611 fluid;
        this.capacity = nbt.method_10537(TAG_CAPACITY);
        if (nbt.method_10573(TAG_FLUID, 10)) {
            this.setFluid(FluidStack.loadFluidStackFromNBT((class_2487)nbt.method_10562(TAG_FLUID)));
        }
        if (nbt.method_10573(TAG_FILTER, 8) && (fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(nbt.method_10558(TAG_FILTER)))) != null) {
            this.filter = fluid;
        }
    }

    public class_2487 writeToTag(class_2487 nbt) {
        nbt.method_10544(TAG_CAPACITY, this.capacity);
        if (!this.fluid.isEmpty()) {
            nbt.method_10566(TAG_FLUID, (class_2520)this.fluid.writeToNBT(new class_2487()));
        }
        if (this.filter != class_3612.field_15906) {
            nbt.method_10582(TAG_FILTER, Objects.requireNonNull(class_7923.field_41173.method_10221((Object)this.filter)).toString());
        }
        return nbt;
    }

    public CastingFluidHandler(CastingBlockEntity tile) {
        this.tile = tile;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public record Snapshot(long capacity, FluidStack fluidStack, class_3611 filter) {
    }
}

