/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.models.CompositeModel;
import io.github.fabricators_of_create.porting_lib.models.UnbakedGeometryHelper;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import io.github.fabricators_of_create.porting_lib.models.geometry.SimpleModelState;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_638;
import net.minecraft.class_7764;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;

public final class CopperCanModel
implements IUnbakedGeometry<CopperCanModel> {
    public static final Loader LOADER = new Loader();
    private static final class_4590 FLUID_TRANSFORM = new class_4590(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final class_4590 COVER_TRANSFORM = new class_4590(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.004f), new Quaternionf());
    @Nonnull
    private final FluidStack fluid;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        List quads;
        List unbaked;
        SimpleModelState transformedState;
        class_1058 templateSprite;
        class_1058 particleSprite;
        class_4730 particleLocation = owner.method_3432("particle") ? owner.method_24077("particle") : null;
        class_4730 baseLocation = owner.method_3432("base") ? owner.method_24077("base") : null;
        class_4730 fluidMaskLocation = owner.method_3432("fluid") ? owner.method_24077("fluid") : null;
        class_4730 coverLocation = owner.method_3432("cover") ? owner.method_24077("cover") : null;
        class_1058 baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        class_1058 fluidSprite = FluidVariantRendering.getSprite((FluidVariant)this.fluid.getType());
        class_1058 coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        class_1058 class_10582 = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (!this.fluid.isEmpty() && FluidVariantAttributes.isLighterThanAir((FluidVariant)this.fluid.getType())) {
            modelTransform = new SimpleModelState(modelTransform.method_3509().method_22933(new class_4590(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((boolean)owner.method_3444(), (boolean)false, (boolean)owner.method_24298().method_24299(), (class_1058)particleSprite, (class_806)new ContainedFluidOverrideHandler(overrides, baker, owner, this), (class_809)owner.method_3443());
        if (baseLocation != null && baseSprite != null) {
            List unbaked2 = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (class_7764)baseSprite.method_45851());
            List quads2 = UnbakedGeometryHelper.bakeElements((List)unbaked2, $ -> baseSprite, (class_3665)modelTransform, (class_2960)modelLocation);
            modelBuilder.addQuads((Collection)quads2);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            transformedState = new SimpleModelState(modelTransform.method_3509().method_22933(FLUID_TRANSFORM), modelTransform.method_3512());
            unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (class_7764)templateSprite.method_45851());
            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (class_3665)transformedState, (class_2960)modelLocation);
            modelBuilder.addQuads((Collection)quads);
        }
        if (coverSprite != null) {
            class_1058 sprite;
            class_1058 class_10583 = sprite = this.coverIsMask ? baseSprite : coverSprite;
            if (sprite != null) {
                transformedState = new SimpleModelState(modelTransform.method_3509().method_22933(COVER_TRANSFORM), modelTransform.method_3512());
                unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (class_7764)coverSprite.method_45851());
                quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (class_3665)transformedState, (class_2960)modelLocation);
                modelBuilder.addQuads((Collection)quads);
            }
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    public CopperCanModel(@Nonnull FluidStack fluid, boolean coverIsMask, boolean applyFluidLuminosity) {
        if (fluid == null) {
            throw new NullPointerException("fluid is marked non-null but is null");
        }
        this.fluid = fluid;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public CopperCanModel withFluid(@Nonnull FluidStack fluid) {
        if (fluid == null) {
            throw new NullPointerException("fluid is marked non-null but is null");
        }
        return this.fluid == fluid ? this : new CopperCanModel(fluid, this.coverIsMask, this.applyFluidLuminosity);
    }

    private static final class ContainedFluidOverrideHandler
    extends class_806 {
        private static final class_2960 BAKE_LOCATION = TConstruct.getResource("copper_can_dynamic");
        private final Map<FluidStack, class_1087> cache = Maps.newHashMap();
        private final class_806 nested;
        private final class_7775 baker;
        private final class_793 owner;
        private final CopperCanModel parent;

        private ContainedFluidOverrideHandler(class_806 nested, class_7775 baker, class_793 owner, CopperCanModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        private class_1087 getUncahcedModel(FluidStack fluid) {
            return this.parent.withFluid(fluid).bake(this.owner, this.baker, class_4730::method_24148, (class_3665)class_1086.field_5350, class_806.field_4292, BAKE_LOCATION, false);
        }

        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
            class_1087 overriden = this.nested.method_3495(originalModel, stack, world, entity, seed);
            if (overriden != originalModel) {
                return overriden;
            }
            class_3611 fluid = CopperCanItem.getFluid(stack.method_7969());
            if (fluid != class_3612.field_15906) {
                FluidStack fluidStack = new FluidStack(fluid, 9000L, CopperCanItem.getFluidTag(stack.method_7969()));
                return this.cache.computeIfAbsent(fluidStack, this::getUncahcedModel);
            }
            return originalModel;
        }
    }

    private static class Loader
    implements IGeometryLoader<CopperCanModel> {
        private Loader() {
        }

        public CopperCanModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            boolean coverIsMask = class_3518.method_15258((JsonObject)modelContents, (String)"coverIsMask", (boolean)true);
            boolean applyFluidLuminosity = class_3518.method_15258((JsonObject)modelContents, (String)"applyFluidLuminosity", (boolean)true);
            return new CopperCanModel(FluidStack.EMPTY, coverIsMask, applyFluidLuminosity);
        }
    }
}

