/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.inventory;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.material.MaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.block.entity.table.PartBuilderBlockEntity;

public class PartBuilderContainerWrapper
implements IPartBuilderContainer {
    private final PartBuilderBlockEntity builder;
    private boolean materialNeedsUpdate = true;
    @Nullable
    private IMaterialValue material = null;

    public PartBuilderContainerWrapper(PartBuilderBlockEntity builder) {
        this.builder = builder;
    }

    public class_1799 getStack() {
        return this.builder.method_5438(0);
    }

    @Override
    public class_1799 getPatternStack() {
        return this.builder.method_5438(1);
    }

    protected class_1937 getWorld() {
        return Objects.requireNonNull(this.builder.method_10997(), "Tile entity world must be nonnull");
    }

    public void refreshMaterial() {
        this.materialNeedsUpdate = true;
        this.material = null;
    }

    @Override
    @Nullable
    public IMaterialValue getMaterial() {
        if (this.materialNeedsUpdate) {
            this.materialNeedsUpdate = false;
            class_1799 stack = this.getStack();
            if (stack.method_7960()) {
                this.material = null;
            } else if (stack.method_31573(TinkerTags.Items.TOOL_PARTS)) {
                MaterialVariantId material = IMaterialItem.getMaterialFromStack(stack);
                this.material = IMaterial.UNKNOWN_ID.matchesVariant(material) ? null : new MaterialValue(material, MaterialCastingLookup.getItemCost(stack.method_7909()));
            } else {
                class_1937 world = this.getWorld();
                this.material = world.method_8433().method_8132((class_3956)TinkerRecipeTypes.MATERIAL.get(), (class_1263)this, world).orElse(null);
            }
        }
        return this.material;
    }
}

