/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.event.common.ExplosionEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_8103;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class BlastProtectionModifier
extends AbstractProtectionModifier<BlastData> {
    private static final TinkerDataCapability.TinkerDataKey<BlastData> BLAST_DATA = TConstruct.createKey("blast_protection");

    public BlastProtectionModifier() {
        super(BLAST_DATA);
        ExplosionEvents.DETONATE.register(BlastProtectionModifier::onExplosionDetonate);
        LivingEntityEvents.LivingTickEvent.TICK.register(BlastProtectionModifier::livingTick);
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1282 source, float modifierValue) {
        if (!source.method_48789(class_8103.field_42243) && !source.method_48789(class_8103.field_42242) && source.method_48789(class_8103.field_42249)) {
            modifierValue += this.getScaledLevel(tool, level) * 2.5f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.5f, tooltip);
    }

    @Override
    protected BlastData createData() {
        return new BlastData();
    }

    @Override
    protected void reset(BlastData data) {
        data.wasKnockback = false;
    }

    private static void onExplosionDetonate(class_1937 world, class_1927 explosion, List<class_1297> list, double d) {
        class_243 center = new class_243(explosion.field_9195, explosion.field_9192, explosion.field_9189);
        float diameter = explosion.field_9190 * 2.0f;
        for (class_1297 entity : list) {
            if (entity.method_5659()) continue;
            TinkerDataCapability.CAPABILITY.maybeGet((Object)entity).ifPresent(data -> {
                BlastData blastData = data.get(BLAST_DATA);
                if (blastData != null && blastData.getMax() > 0.0f) {
                    double y;
                    double distance;
                    double x = entity.method_23317() - center.field_1352;
                    double z = entity.method_23321() - center.field_1350;
                    if ((x != 0.0 || z != 0.0 || entity.method_23320() - center.field_1351 != 0.0) && (distance = (double)(class_3532.method_15355((float)((float)(x * x + (y = entity.method_23318() - center.field_1351) * y + z * z))) / diameter)) <= 1.0) {
                        blastData.wasKnockback = true;
                    }
                }
            });
        }
    }

    private static void livingTick(LivingEntityEvents.LivingTickEvent event) {
        class_1309 living = event.getEntity();
        if (!living.method_37908().field_9236 && !living.method_7325()) {
            TinkerDataCapability.CAPABILITY.maybeGet((Object)living).ifPresent(data -> {
                BlastData blastData = data.get(BLAST_DATA);
                if (blastData != null && blastData.wasKnockback) {
                    blastData.wasKnockback = false;
                    float max = blastData.getMax();
                    if (max > 0.0f) {
                        double scale = 1.0f - blastData.getMax() * 0.15f;
                        if (scale <= 0.0) {
                            living.method_18799(class_243.field_1353);
                        } else {
                            living.method_18799(living.method_18798().method_18805(scale, scale, scale));
                        }
                        living.field_6037 = true;
                    }
                }
            });
        }
    }

    protected static class BlastData
    extends ModifierMaxLevel {
        boolean wasKnockback = false;

        protected BlastData() {
        }
    }
}

