/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class DwarvenModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final class_2561 MINING_SPEED = TConstruct.makeTranslation("modifier", "dwarven.mining_speed");
    private static final class_2561 VELOCITY = TConstruct.makeTranslation("modifier", "dwarven.velocity");
    private static final float BOOST_DISTANCE = 64.0f;
    private static final float DEBUFF_RANGE = 128.0f;
    private static final float MINING_BONUS = 6.0f;
    private static final float VELOCITY_BONUS = 0.05f;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT);
    }

    private static float getBoost(class_1937 world, float y, int level, float baseSpeed, float modifier, float bonus) {
        if (y < 64.0f) {
            float scale = class_3532.method_15363((float)((64.0f - y) / 64.0f), (float)0.0f, (float)2.0f);
            return baseSpeed + (float)level * scale * bonus * modifier;
        }
        float baselineDebuff = Math.max((float)world.method_31600() - 192.0f, 96.0f);
        if (y > baselineDebuff) {
            if (y >= baselineDebuff + 128.0f) {
                return baseSpeed * 0.25f;
            }
            return baseSpeed * (1.0f - (y - baselineDebuff) / 128.0f * 0.75f);
        }
        return baseSpeed;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvents.BreakSpeed event, class_2350 sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!isEffective) {
            return;
        }
        event.setNewSpeed(DwarvenModifier.getBoost(event.getPlayer().method_37908(), event.getPos().method_10264(), level, event.getNewSpeed(), miningSpeedModifier * tool.getMultiplier(ToolStats.MINING_SPEED), 6.0f));
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, class_1309 living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.VELOCITY) {
            return DwarvenModifier.getBoost(living.method_37908(), (float)living.method_23318(), modifier.getLevel(), baseValue, multiplier, 0.05f);
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            double boost;
            float baseBoost;
            class_2561 prefix = harvest ? MINING_SPEED : VELOCITY;
            float f = baseBoost = harvest ? 6.0f : 0.05f;
            if (player != null && key == TooltipKey.SHIFT) {
                boost = DwarvenModifier.getBoost(player.method_37908(), (float)player.method_23318(), level, 1.0f, 1.0f, baseBoost) - 1.0f;
                if (boost < 0.0) {
                    if (boost <= -0.01) {
                        this.addPercentTooltip(prefix, boost, tooltip);
                    }
                    return;
                }
            } else {
                boost = baseBoost * (float)level;
            }
            if (boost >= 0.01) {
                this.addFlatBoost(prefix, boost * (double)tool.getMultiplier(harvest ? ToolStats.MINING_SPEED : ToolStats.VELOCITY), tooltip);
            }
        }
    }
}

