/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1836;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MomentumModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ConditionalStatModifierHook {
    private static final class_2561 SPEED = TConstruct.makeTranslation("modifier", "momentum.speed");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.PROJECTILE_LAUNCH);
    }

    @Override
    public int getPriority() {
        return 75;
    }

    private static float getBonus(class_1309 living, RegistryObject<? extends TinkerEffect> effect, int level, float scale) {
        int effectLevel = ((TinkerEffect)((Object)effect.get())).getLevel(living) + 1;
        return (float)(level * effectLevel) / scale;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvents.BreakSpeed event, class_2350 sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + MomentumModifier.getBonus((class_1309)event.getEntity(), TinkerModifiers.momentumEffect, level, 128.0f)));
        }
    }

    @Override
    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        if (context.canHarvest() && context.isEffective() && !context.isAOE()) {
            class_1309 living = context.getLiving();
            int effectLevel = Math.min(31, ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).getLevel(living) + 1);
            int duration = (int)(10.0f / tool.getStats().get(ToolStats.MINING_SPEED).floatValue() * 1.5f * 20.0f);
            ((TinkerEffect)((Object)TinkerModifiers.momentumEffect.get())).apply(living, duration, effectLevel, true);
        }
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, class_1309 shooter, class_1676 projectile, @Nullable class_1665 arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.method_7443())) {
            int effectLevel = Math.min(15, ((TinkerEffect)((Object)TinkerModifiers.momentumRangedEffect.get())).getLevel(shooter) + 1);
            ((TinkerEffect)((Object)TinkerModifiers.momentumRangedEffect.get())).apply(shooter, 100, effectLevel, true);
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, class_1309 living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.DRAW_SPEED) {
            return baseValue * (1.0f + MomentumModifier.getBonus(living, TinkerModifiers.momentumRangedEffect, modifier.getLevel(), 64.0f));
        }
        return baseValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey key, class_1836 flag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            float bonus = player != null && key == TooltipKey.SHIFT ? (harvest ? MomentumModifier.getBonus((class_1309)player, TinkerModifiers.momentumEffect, level, 128.0f) : MomentumModifier.getBonus((class_1309)player, TinkerModifiers.momentumRangedEffect, level, 64.0f)) : (float)level * 0.25f;
            if (bonus > 0.0f) {
                this.addPercentTooltip(SPEED, bonus, tooltip);
            }
        }
    }
}

