/*
 * Decompiled with CFR 0.152.
 */
package github.fnewell.playerstatistics;

import github.fnewell.playerstatistics.db.DriverUtils;
import github.fnewell.playerstatistics.utils.CommandUtils;
import github.fnewell.playerstatistics.utils.ConfigUtils;
import github.fnewell.playerstatistics.utils.StatSyncScheduler;
import github.fnewell.playerstatistics.webserver.WebServer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerStatistics
implements ModInitializer {
    public static final String MOD_ID = "player-statistics";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"player-statistics");
    public static boolean DEBUG = false;
    private static boolean cleanedUp = false;
    public static List<ExecutorService> executors = new ArrayList<ExecutorService>();

    public void onInitialize() {
        LOGGER.info("Loading Player Statistics ...");
        if (!ConfigUtils.initializeConfig()) {
            LOGGER.error("Failed to initialize config. Mod is not loaded!");
            return;
        }
        if (DEBUG) {
            LOGGER.info("Debug mode is enabled!");
        }
        DriverUtils.checkDrivers();
        DriverUtils.registerSQLite();
        if (DEBUG) {
            LOGGER.info("Registering commands ...");
        }
        CommandUtils.registerCommands();
        if (DEBUG) {
            LOGGER.info("Commands registered!");
        }
        ServerLifecycleEvents.SERVER_STARTED.register(server -> StatSyncScheduler.startScheduledSync());
        if (ConfigUtils.config.getBoolean("web-server.enabled")) {
            if (DEBUG) {
                LOGGER.info("Starting web server ...");
            }
            WebServer.startServer();
            if (DEBUG) {
                LOGGER.info("Web server started!");
            }
        }
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> PlayerStatistics.cleanup());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> PlayerStatistics.cleanup());
        LOGGER.info("Player Statistics successfully loaded!");
    }

    private static void cleanup() {
        if (DEBUG) {
            LOGGER.info("Cleaning up ...");
        }
        if (cleanedUp) {
            if (DEBUG) {
                LOGGER.info("Cleanup already completed!");
            }
            return;
        }
        for (ExecutorService executor : executors) {
            if (DEBUG) {
                LOGGER.info("Shutting down executor ...");
            }
            executor.shutdownNow();
        }
        if (DEBUG) {
            LOGGER.info("Shutting down CommandUtils executor ...");
        }
        CommandUtils.executor.shutdownNow();
        if (DEBUG) {
            LOGGER.info("Stopping scheduled synchronization ...");
        }
        StatSyncScheduler.stopScheduledSync();
        if (DEBUG) {
            LOGGER.info("Stopping web server ...");
        }
        WebServer.stopServer();
        cleanedUp = true;
        if (DEBUG) {
            LOGGER.info("Cleanup completed!");
        }
    }
}

