/*
 * Decompiled with CFR 0.152.
 */
package github.fnewell.playerstatistics.db;

import github.fnewell.playerstatistics.PlayerStatistics;
import github.fnewell.playerstatistics.db.DriverShim;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class DriverUtils {
    public static DriverShim customDriverShim;

    public static void registerSQLite() {
        try {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Registering custom SQLite JDBC driver ...");
            }
            Path driverPath = FabricLoader.getInstance().getGameDir().resolve("mods/player-statistics/libs/sqlite-jdbc-3.47.1.0.jar");
            URL driverUrl = driverPath.toUri().toURL();
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Driver URL: {}", (Object)driverUrl);
            }
            URLClassLoader loader = new URLClassLoader(new URL[]{driverUrl}, ClassLoader.getPlatformClassLoader());
            Class<?> driverClass = Class.forName("org.sqlite.JDBC", true, loader);
            Driver customDriver = (Driver)driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Driver Class: {}; Loaded from: {}", (Object)customDriver.getClass().getName(), (Object)customDriver.getClass().getProtectionDomain().getCodeSource().getLocation());
            }
            customDriverShim = new DriverShim(customDriver);
            DriverManager.registerDriver(customDriverShim);
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Custom SQLite JDBC driver registered!");
            }
        }
        catch (Exception e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Failed to register custom SQLite driver via DriverShim: {}", (Object)e.getMessage());
        }
    }

    public static void checkDrivers() {
        try {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Checking for required drivers ...");
            }
            Map<String, String> drivers = Map.of("sqlite-jdbc-3.47.1.0.jar", "https://repo1.maven.org/maven2/org/xerial/sqlite-jdbc/3.47.1.0/sqlite-jdbc-3.47.1.0.jar", "mariadb-java-client-3.5.1.jar", "https://repo1.maven.org/maven2/org/mariadb/jdbc/mariadb-java-client/3.5.1/mariadb-java-client-3.5.1.jar", "postgresql-42.7.4.jar", "https://repo1.maven.org/maven2/org/postgresql/postgresql/42.7.4/postgresql-42.7.4.jar");
            DriverUtils.ensureDriversExist(drivers, FabricLoader.getInstance().getGameDir().resolve("mods/player-statistics/libs"));
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Required drivers checked!");
            }
        }
        catch (Exception e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Failed to check required drivers: {}", (Object)e.getMessage());
        }
    }

    public static void ensureDriversExist(Map<String, String> drivers, Path driverFolder) throws IOException, InterruptedException {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Checking for required drivers (ensureDriversExist)...");
        }
        if (!Files.exists(driverFolder, new LinkOption[0])) {
            Files.createDirectories(driverFolder, new FileAttribute[0]);
        }
        for (Map.Entry<String, String> entry : drivers.entrySet()) {
            String fileName = entry.getKey();
            String downloadUrl = entry.getValue();
            Path filePath = driverFolder.resolve(fileName);
            if (!Files.exists(filePath, new LinkOption[0])) {
                DriverUtils.downloadFile(downloadUrl, filePath);
                continue;
            }
            if (!PlayerStatistics.DEBUG) continue;
            PlayerStatistics.LOGGER.info("Driver {} already exists.", (Object)fileName);
        }
    }

    private static void downloadFile(String fileUrl, Path destination) throws IOException, InterruptedException {
        HttpResponse<Path> response;
        PlayerStatistics.LOGGER.info("Downloading {} to {}", (Object)fileUrl, (Object)destination);
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(fileUrl)).GET().build();
            response = client.send(request, HttpResponse.BodyHandlers.ofFile(destination));
        }
        if (response.statusCode() != 200) {
            throw new IOException("Failed to download file: " + fileUrl + " (HTTP " + response.statusCode() + ")");
        }
        PlayerStatistics.LOGGER.info("... successfully downloaded");
    }
}

