/*
 * Decompiled with CFR 0.152.
 */
package github.fnewell.playerstatistics.utils;

import com.mojang.logging.LogUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import github.fnewell.playerstatistics.PlayerStatistics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigUtils {
    private static final Path configDir = FabricLoader.getInstance().getConfigDir();
    private static final String CONFIG_FILE_NAME = "player-statistics.conf";
    public static Config config;

    public static boolean initializeConfig() {
        Path modConfigDir = configDir.resolve("player-statistics");
        if (!Files.exists(modConfigDir, new LinkOption[0])) {
            try {
                Files.createDirectories(modConfigDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                PlayerStatistics.LOGGER.error("Failed to create config directory, with error: {}", (Object)e.getMessage());
                return false;
            }
        }
        if (Files.notExists(modConfigDir.resolve(CONFIG_FILE_NAME), new LinkOption[0]) && !ConfigUtils.copyDefaultConfig(modConfigDir)) {
            return false;
        }
        Path modDataDir = FabricLoader.getInstance().getGameDir().resolve("mods/player-statistics");
        if (!Files.exists(modDataDir, new LinkOption[0])) {
            try {
                Files.createDirectories(modDataDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                PlayerStatistics.LOGGER.error("Failed to create data directory, with error: {}", (Object)e.getMessage());
                return false;
            }
        }
        return (config = ConfigUtils.loadConfig()) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean copyDefaultConfig(Path modConfigDir) {
        Path configFile = modConfigDir.resolve(CONFIG_FILE_NAME);
        if (Files.exists(configFile, new LinkOption[0])) return true;
        try (InputStream in = ConfigUtils.class.getResourceAsStream("/default_player-statistics.conf");){
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            Files.copy(in, configFile, new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            PlayerStatistics.LOGGER.error("Failed to copy default config file, with error: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static Config loadConfig() {
        Path configFile = configDir.resolve("player-statistics").resolve(CONFIG_FILE_NAME);
        if (Files.exists(configFile, new LinkOption[0])) {
            try {
                String stats_folder;
                Config conf_file = ConfigFactory.parseFile((File)configFile.toFile(), (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(true));
                if (conf_file.isEmpty()) {
                    PlayerStatistics.LOGGER.warn("Config file is empty!");
                    return null;
                }
                if (!(conf_file.hasPath("sync-thread-count") && conf_file.hasPath("sync-interval") && conf_file.hasPath("web-server-section") && conf_file.hasPath("database-section"))) {
                    PlayerStatistics.LOGGER.warn("Config file is missing required keys!");
                    return null;
                }
                int sync_thread_count = conf_file.getInt("sync-thread-count");
                int cpu_count = Runtime.getRuntime().availableProcessors();
                if (sync_thread_count == 0) {
                    sync_thread_count = cpu_count;
                } else if (sync_thread_count < 0) {
                    if ((sync_thread_count = cpu_count - sync_thread_count) < 1) {
                        sync_thread_count = 1;
                    }
                } else if (sync_thread_count > cpu_count) {
                    sync_thread_count = cpu_count;
                }
                int sync_interval = conf_file.getInt("sync-interval");
                try {
                    stats_folder = conf_file.getString("stats-folder");
                    if (stats_folder == null || stats_folder.isEmpty()) {
                        stats_folder = "world/stats";
                    } else if (stats_folder.startsWith("/") || stats_folder.endsWith("/")) {
                        stats_folder = stats_folder.replaceAll("^/|/$", "");
                    }
                }
                catch (ConfigException.Missing ignored) {
                    stats_folder = "world/stats";
                }
                Config database = conf_file.getConfig("database-section");
                if (!database.hasPath("location")) {
                    LogUtils.getLogger().warn("Database location is missing!");
                    return null;
                }
                String db_location = database.getString("location");
                if (!db_location.equals("REMOTE") && !db_location.equals("LOCAL")) {
                    LogUtils.getLogger().warn("Database location is invalid!");
                    return null;
                }
                Config webServer = conf_file.getConfig("web-server-section");
                if (webServer.getBoolean("enabled")) {
                    int web_server_port = webServer.getInt("port");
                    if (!database.getString("location").equals("LOCAL")) {
                        db_location = "LOCAL";
                        database = database.withValue("location", ConfigValueFactory.fromAnyRef((Object)"LOCAL"));
                    }
                }
                if (!(!db_location.equals("REMOTE") || database.hasPath("type") && database.hasPath("name") && database.hasPath("host") && database.hasPath("port") && database.hasPath("username") && database.hasPath("password"))) {
                    LogUtils.getLogger().warn("Remote database is missing required keys!");
                    return null;
                }
                if (db_location.equals("LOCAL")) {
                    database = database.withValue("type", ConfigValueFactory.fromAnyRef((Object)"SQLITE"));
                }
                try {
                    PlayerStatistics.DEBUG = conf_file.getBoolean("debug");
                }
                catch (ConfigException.Missing missing) {
                    // empty catch block
                }
                return ConfigFactory.empty().withValue("sync-thread-count", ConfigValueFactory.fromAnyRef((Object)sync_thread_count)).withValue("sync-interval", ConfigValueFactory.fromAnyRef((Object)sync_interval)).withValue("stats-folder", ConfigValueFactory.fromAnyRef((Object)stats_folder)).withValue("web-server", (ConfigValue)webServer.root()).withValue("database", (ConfigValue)database.root());
            }
            catch (Exception e) {
                PlayerStatistics.LOGGER.error("Failed to load config file, with error: {}", (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }
}

