/*
 * Decompiled with CFR 0.152.
 */
package github.fnewell.playerstatistics.utils;

import github.fnewell.playerstatistics.PlayerStatistics;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class DatabaseInitializer {
    public static void initializeDatabase(Connection connection, String dbType) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Initializing database ... \n ({}, {})", (Object)connection, (Object)dbType);
        }
        String idDefinition = dbType.equalsIgnoreCase("SQLITE") ? "INTEGER PRIMARY KEY" : "INT NOT NULL AUTO_INCREMENT PRIMARY KEY";
        String charset = dbType.equalsIgnoreCase("MYSQL") || dbType.equalsIgnoreCase("MARIADB") ? " CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci" : "";
        String[] createTableStatements = new String[]{"CREATE TABLE IF NOT EXISTS uuid_map (id " + idDefinition + ",player_uuid " + DatabaseInitializer.getUUIDType(dbType) + " NOT NULL UNIQUE,player_nick VARCHAR(16) DEFAULT NULL,player_last_online " + DatabaseInitializer.getTimestampType(dbType) + " DEFAULT NULL)" + charset, "CREATE TABLE IF NOT EXISTS sync_metadata (last_update " + DatabaseInitializer.getTimestampType(dbType) + " DEFAULT NULL,server_name VARCHAR(256) DEFAULT NULL,server_desc VARCHAR(256) DEFAULT NULL,server_url VARCHAR(256) DEFAULT NULL,server_icon BLOB DEFAULT NULL,PRIMARY KEY (last_update))" + charset, "CREATE TABLE IF NOT EXISTS hall_of_fame (player_id INT NOT NULL,first_place INT NOT NULL,second_place INT NOT NULL,third_place INT NOT NULL,fourth_place INT NOT NULL,fifth_place INT NOT NULL,score INT NOT NULL,PRIMARY KEY (player_id),FOREIGN KEY (player_id) REFERENCES uuid_map(id) ON DELETE CASCADE)" + charset, DatabaseInitializer.createStatsTableSQL("broken", charset), "CREATE INDEX IF NOT EXISTS idx_broken_position ON `broken` (position)", DatabaseInitializer.createStatsTableSQL("crafted", charset), "CREATE INDEX IF NOT EXISTS idx_crafted_position ON `crafted` (position)", DatabaseInitializer.createStatsTableSQL("custom", charset), "CREATE INDEX IF NOT EXISTS idx_custom_position ON `custom` (position)", DatabaseInitializer.createStatsTableSQL("dropped", charset), "CREATE INDEX IF NOT EXISTS idx_dropped_position ON `dropped` (position)", DatabaseInitializer.createStatsTableSQL("killed", charset), "CREATE INDEX IF NOT EXISTS idx_killed_position ON `killed` (position)", DatabaseInitializer.createStatsTableSQL("killed_by", charset), "CREATE INDEX IF NOT EXISTS idx_killed_by_position ON `killed_by` (position)", DatabaseInitializer.createStatsTableSQL("mined", charset), "CREATE INDEX IF NOT EXISTS idx_mined_position ON `mined` (position)", DatabaseInitializer.createStatsTableSQL("picked_up", charset), "CREATE INDEX IF NOT EXISTS idx_picked_up_position ON `picked_up` (position)", DatabaseInitializer.createStatsTableSQL("used", charset), "CREATE INDEX IF NOT EXISTS idx_used_position ON `used` (position)"};
        try {
            for (String sql : createTableStatements) {
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    statement.execute();
                }
            }
            if (!DatabaseInitializer.isLastUpdateInitialized(connection)) {
                DatabaseInitializer.initializeLastUpdate(connection, dbType);
            }
        }
        catch (SQLException e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error initializing database: {}", (Object)e.getMessage());
        }
    }

    private static String createStatsTableSQL(String tableName, String charset) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Creating table: {}", (Object)tableName);
        }
        return "CREATE TABLE IF NOT EXISTS `" + tableName + "` (player_id INT NOT NULL,position INT(2) NULL,stat_name VARCHAR(256) NOT NULL,amount INT NOT NULL,PRIMARY KEY (player_id, stat_name),FOREIGN KEY (player_id) REFERENCES uuid_map(id) ON DELETE CASCADE)" + charset;
    }

    private static String getTimestampType(String dbType) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Getting timestamp type for: {}", (Object)dbType);
        }
        return switch (dbType) {
            case "MARIADB", "MYSQL" -> "DATETIME";
            case "POSTGRESQL" -> "TIMESTAMP";
            case "SQLITE" -> "TEXT";
            default -> throw new IllegalArgumentException("Not supported database type (getTimestampType): " + dbType);
        };
    }

    private static String getUUIDType(String dbType) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Getting UUID type for: {}", (Object)dbType);
        }
        return switch (dbType) {
            case "MARIADB", "MYSQL", "SQLITE" -> "VARCHAR(36)";
            case "POSTGRESQL" -> "UUID";
            default -> throw new IllegalArgumentException("Not supported database type (getUUIDType): " + dbType);
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isLastUpdateInitialized(Connection connection) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Checking if last_update is initialized ...");
        }
        String sql = "SELECT COUNT(*) FROM sync_metadata WHERE last_update IS NOT NULL";
        try (PreparedStatement statement = connection.prepareStatement(sql);
             ResultSet resultSet = statement.executeQuery();){
            if (!resultSet.next()) return false;
            boolean bl = resultSet.getInt(1) > 0;
            return bl;
        }
        catch (SQLException e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error checking if last_update is initialized: {}", (Object)e.getMessage());
        }
        return false;
    }

    private static void initializeLastUpdate(Connection connection, String dbType) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Initializing last_update ...");
        }
        String sql = "INSERT INTO sync_metadata (last_update) VALUES (?)";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            if ("SQLITE".equalsIgnoreCase(dbType)) {
                statement.setString(1, "1970-01-01 00:00:00");
            } else {
                statement.setTimestamp(1, new Timestamp(0L));
            }
            statement.executeUpdate();
        }
        catch (SQLException e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error initializing last_update: {}", (Object)e.getMessage());
        }
    }
}

