/*
 * Decompiled with CFR 0.152.
 */
package github.fnewell.playerstatistics.utils;

import github.fnewell.playerstatistics.PlayerStatistics;
import github.fnewell.playerstatistics.utils.ConfigUtils;
import github.fnewell.playerstatistics.utils.StatSyncTask;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StatSyncScheduler {
    private static boolean isScheduled = false;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void startScheduledSync() {
        int intervalMinutes;
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Starting scheduled synchronization ...");
        }
        if ((intervalMinutes = ConfigUtils.config.getInt("sync-interval")) <= 0) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Scheduled synchronization is disabled.");
            }
            return;
        }
        scheduler.scheduleAtFixedRate(() -> {
            if (Objects.equals(StatSyncTask.status, "Idle")) {
                try {
                    StatSyncTask.syncAllPlayerStats();
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Scheduled synchronization task completed successfully.");
                    }
                }
                catch (Exception e) {
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                    }
                    PlayerStatistics.LOGGER.error("An error occurred while trying to schedule the synchronization task: {}", (Object)e.getMessage());
                }
            }
        }, 1L, intervalMinutes, TimeUnit.MINUTES);
        isScheduled = true;
        PlayerStatistics.LOGGER.info("Player stats synchronization was successfully scheduled with an interval of {} minutes.", (Object)intervalMinutes);
    }

    public static void stopScheduledSync() {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Stopping scheduled synchronization ...");
        }
        if (!isScheduled) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Scheduled synchronization is not running.");
            }
            return;
        }
        PlayerStatistics.LOGGER.info("Stopping scheduled synchronization ...");
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(3L, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            scheduler.shutdownNow();
        }
        isScheduled = false;
    }
}

