/*
 * Decompiled with CFR 0.152.
 */
package github.fnewell.playerstatistics.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import github.fnewell.playerstatistics.PlayerStatistics;
import github.fnewell.playerstatistics.utils.ConfigUtils;
import github.fnewell.playerstatistics.utils.DatabaseInitializer;
import github.fnewell.playerstatistics.utils.DatabaseUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class StatSyncTask {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static String status = "Idle";
    public static String lastSync = "Never";
    public static int progressFrom = 0;
    public static int progressTo = 0;
    public static int playersToUpdate = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean syncAllPlayerStats() {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Synchronizing player stats ...");
        }
        try (Connection connection = DatabaseUtils.getDatabaseConnection();){
            Path serverIconPath;
            File serverPropertiesFile;
            Timestamp lastGlobalSyncTime;
            Path statsDir;
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Database connection established.");
            }
            status = "Initializing";
            String DbType = ConfigUtils.config.getString("database.type");
            if ("LOCAL".equals(DatabaseUtils.DB_LOCATION)) {
                DbType = "SQLITE";
            }
            DatabaseInitializer.initializeDatabase(connection, DbType);
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Database initialized.");
            }
            if (!Files.exists(statsDir = Path.of(ConfigUtils.config.getString("stats-folder"), new String[0]), new LinkOption[0])) {
                PlayerStatistics.LOGGER.warn("Stats folder not found, skipping synchronization.");
                status = "Idle";
                boolean bl = false;
                return bl;
            }
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Stats folder found.");
            }
            if ((lastGlobalSyncTime = DatabaseUtils.getLastSyncTime(connection)) == null) {
                lastGlobalSyncTime = new Timestamp(0L);
            }
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Last global sync time: {}", (Object)lastGlobalSyncTime);
            }
            HashMap<UUID, Timestamp> fileTimestamps = new HashMap<UUID, Timestamp>();
            HashMap<UUID, Path> playerFiles = new HashMap<UUID, Path>();
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(statsDir, "*.json");){
                for (Path statsFile : directoryStream) {
                    UUID playerUUID2 = StatSyncTask.extractUUIDFromFile(statsFile);
                    if (playerUUID2 == null) continue;
                    Timestamp lastModified2 = new Timestamp(Files.getLastModifiedTime(statsFile, new LinkOption[0]).toMillis());
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("... Player UUID: {} / Last modified: {}", (Object)playerUUID2, (Object)lastModified2);
                    }
                    fileTimestamps.put(playerUUID2, lastModified2);
                    playerFiles.put(playerUUID2, statsFile);
                }
            }
            catch (IOException e) {
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                }
                PlayerStatistics.LOGGER.error("Error while reading stats folder: {}", (Object)e.getMessage());
                status = "Idle";
                boolean bl = false;
                if (connection == null) return bl;
                connection.close();
                return bl;
            }
            progressTo = fileTimestamps.size();
            status = "Syncing data";
            Map<String, Timestamp> dbPlayers = DatabaseUtils.fetchPlayerDataFromDatabase(connection);
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Syncing player stats ...");
            }
            try (ExecutorService executor = Executors.newFixedThreadPool(ConfigUtils.config.getInt("sync-thread-count"));){
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Executor created.");
                }
                PlayerStatistics.executors.add(executor);
                fileTimestamps.forEach((playerUUID, lastModified) -> {
                    Timestamp playerLastOnline = (Timestamp)dbPlayers.get(playerUUID.toString());
                    if (playerLastOnline == null || lastModified.after((Timestamp)dbPlayers.get(playerUUID.toString()))) {
                        ++playersToUpdate;
                        executor.submit(() -> {
                            try {
                                JsonNode rootNode = MAPPER.readTree(((Path)playerFiles.get(playerUUID)).toFile());
                                JsonNode stats = rootNode.get("stats");
                                if (stats != null) {
                                    if (PlayerStatistics.DEBUG) {
                                        PlayerStatistics.LOGGER.info("/Syncing player stats for UUID: {} (executor: {})", playerUUID, (Object)Thread.currentThread().threadId());
                                    }
                                    DatabaseUtils.syncPlayerStats(connection, playerUUID, lastModified, stats);
                                    if (PlayerStatistics.DEBUG) {
                                        PlayerStatistics.LOGGER.info("\\Player stats synced for UUID: {} (executor: {})", playerUUID, (Object)Thread.currentThread().threadId());
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (PlayerStatistics.DEBUG) {
                                    PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                                }
                                PlayerStatistics.LOGGER.error("Error while syncing player stats: {}", (Object)e.getMessage());
                            }
                        });
                    }
                });
                executor.shutdown();
                if (!executor.awaitTermination(3L, TimeUnit.MINUTES)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                }
                PlayerStatistics.LOGGER.error("Executor interrupted: {}", (Object)e.getMessage());
                status = "Idle";
                boolean statsFile = false;
                if (connection == null) return statsFile;
                connection.close();
                return statsFile;
            }
            progressTo = 0;
            progressFrom = 0;
            if (playersToUpdate > 0) {
                status = "Fetching nicks";
                DatabaseUtils.fetchAndUpdateMissingPlayerNicks(connection);
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Player nicks fetched.");
                }
                progressTo = 0;
                progressFrom = 0;
            }
            if (playersToUpdate > 0) {
                status = "Updating positions";
                DatabaseUtils.updatePositionsForTable(connection);
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Player positions updated.");
                }
                progressTo = 0;
                progressFrom = 0;
            }
            if (playersToUpdate > 0) {
                status = "Populating Hall of Fame";
                DatabaseUtils.populateHallOfFame(connection);
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Hall of Fame populated.");
                }
            }
            String serverName = ConfigUtils.config.getString("web-server.server-name");
            String serverDesc = null;
            String serverUrl = ConfigUtils.config.getString("web-server.server-url");
            byte[] serverIcon = null;
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Reading server properties ...");
            }
            if ((serverPropertiesFile = new File("server.properties")).exists()) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(serverPropertiesFile), StandardCharsets.UTF_8));){
                    String line;
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Server properties file found.");
                    }
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("motd=")) continue;
                        serverDesc = line.substring(5);
                        break;
                    }
                }
                catch (IOException e) {
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                    }
                    PlayerStatistics.LOGGER.error("Error while reading server.properties: {}", (Object)e.getMessage());
                    status = "Idle";
                    boolean bl = false;
                    if (connection == null) return bl;
                    connection.close();
                    return bl;
                }
            }
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Reading server icon ...");
            }
            if (Files.exists(serverIconPath = Path.of("server-icon.png", new String[0]), new LinkOption[0])) {
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Server icon found.");
                }
                serverIcon = Files.readAllBytes(serverIconPath);
            }
            DatabaseUtils.updateSyncMetadata(connection, serverName, serverDesc, serverUrl, serverIcon);
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Sync metadata updated.");
            }
            playersToUpdate = 0;
            status = "Idle";
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error while synchronizing player stats: {}", (Object)e.getMessage());
            playersToUpdate = 0;
            status = "Idle";
            return false;
        }
    }

    private static UUID extractUUIDFromFile(Path statsFile) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Extracting UUID from file: {}", (Object)statsFile);
        }
        try {
            String fileName = statsFile.getFileName().toString();
            if (fileName.endsWith(".json")) {
                String uuidPart = fileName.substring(0, fileName.length() - 5);
                return UUID.fromString(uuidPart);
            }
        }
        catch (IllegalArgumentException e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error while extracting UUID from file: {}", (Object)e.getMessage());
        }
        return null;
    }
}

