/*
 * Decompiled with CFR 0.152.
 */
package github.fnewell.playerstatistics.utils;

import com.fasterxml.jackson.databind.JsonNode;
import github.fnewell.playerstatistics.PlayerStatistics;
import github.fnewell.playerstatistics.db.LocalDatabase;
import github.fnewell.playerstatistics.utils.ConfigUtils;
import github.fnewell.playerstatistics.utils.StatSyncTask;
import java.lang.runtime.SwitchBootstraps;
import java.net.HttpURLConnection;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class DatabaseUtils {
    public static final String DB_LOCATION = ConfigUtils.config.getString("database.location");
    private static final String DB_TYPE = ConfigUtils.config.getString("database.type");
    private static final List<String> TABLE_NAMES = Arrays.asList("broken", "crafted", "custom", "dropped", "killed", "killed_by", "mined", "picked_up", "used");

    public static Connection getDatabaseConnection() throws Exception {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Connecting to the database ...");
        }
        if ("REMOTE".equals(DB_LOCATION)) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Connecting to remote database ...");
            }
            String DbType = ConfigUtils.config.getString("database.type");
            String DbName = ConfigUtils.config.getString("database.name");
            String DbHost = ConfigUtils.config.getString("database.host");
            String DbPort = ConfigUtils.config.getString("database.port");
            String DbUser = ConfigUtils.config.getString("database.username");
            String DbPassword = ConfigUtils.config.getString("database.password");
            String url = switch (DbType) {
                case "MARIADB", "MYSQL", "POSTGRESQL" -> "jdbc:" + DbType.toLowerCase() + "://" + DbHost + ":" + DbPort + "/" + DbName;
                case "SQLITE" -> "jdbc:sqlserver://" + DbHost + ":" + DbPort + ";databaseName=" + DbName;
                default -> throw new IllegalArgumentException("Unexpected value: " + DbType);
            };
            return DriverManager.getConnection(url, DbUser, DbPassword);
        }
        if ("LOCAL".equals(DB_LOCATION)) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Connecting to local database ...");
            }
            return LocalDatabase.getConnection();
        }
        throw new IllegalArgumentException("Unsupported database location: " + DB_LOCATION);
    }

    public static Map<String, Timestamp> fetchPlayerDataFromDatabase(Connection connection) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Fetching player data from database...");
        }
        String query = "SELECT player_uuid, player_last_online FROM uuid_map";
        HashMap<String, Timestamp> playerDataMap = new HashMap<String, Timestamp>();
        try (PreparedStatement statement = connection.prepareStatement(query);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String playerUUID = resultSet.getString("player_uuid");
                long lastOnlineMillis = resultSet.getLong("player_last_online");
                Timestamp lastOnline = new Timestamp(lastOnlineMillis);
                playerDataMap.put(playerUUID, lastOnline);
                if (!PlayerStatistics.DEBUG) continue;
                PlayerStatistics.LOGGER.info("Fetched player: UUID = {}, Last Online = {}", (Object)playerUUID, (Object)lastOnline);
            }
        }
        catch (SQLException e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error fetching player data from database: {}", (Object)e.getMessage());
        }
        return playerDataMap;
    }

    public static void fetchAndUpdateMissingPlayerNicks(Connection connection) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Fetching missing player nicks ...");
        }
        String countSQL = "SELECT COUNT(*) AS total FROM uuid_map WHERE player_nick IS NULL";
        String fetchMissingNicksSQL = "SELECT id, player_uuid FROM uuid_map WHERE player_nick IS NULL";
        try (ExecutorService executor = Executors.newFixedThreadPool(ConfigUtils.config.getInt("sync-thread-count"));){
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Executor created (missing nicks)");
            }
            PlayerStatistics.executors.add(executor);
            try (PreparedStatement countStmt = connection.prepareStatement(countSQL);
                 ResultSet countRs = countStmt.executeQuery();){
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Counting missing player nicks ...");
                }
                if (countRs.next()) {
                    StatSyncTask.progressTo = countRs.getInt("total");
                }
            }
            catch (SQLException e) {
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                }
                PlayerStatistics.LOGGER.error("Error counting missing player nicks: {}", (Object)e.getMessage());
            }
            try (PreparedStatement fetchStmt = connection.prepareStatement(fetchMissingNicksSQL);
                 ResultSet rs = fetchStmt.executeQuery();){
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Fetching missing player nicks ...");
                }
                while (rs.next()) {
                    int playerId = rs.getInt("id");
                    String playerUUID = rs.getString("player_uuid");
                    executor.submit(() -> {
                        if (PlayerStatistics.DEBUG) {
                            PlayerStatistics.LOGGER.info("Executor running (missing nicks)");
                        }
                        try {
                            String playerNick = playerUUID.startsWith("00000000-0000-0000-") ? DatabaseUtils.fetchBedrockPlayerNickFromAPI(playerUUID) : DatabaseUtils.fetchJavaPlayerNickFromAPI(playerUUID);
                            if (PlayerStatistics.DEBUG) {
                                PlayerStatistics.LOGGER.info("Fetched nick for UUID: {} ({})", (Object)playerUUID, (Object)playerNick);
                            }
                            if (playerNick != null) {
                                DatabaseUtils.updatePlayerNickInDatabase(connection, playerId, playerNick);
                                if (PlayerStatistics.DEBUG) {
                                    PlayerStatistics.LOGGER.info("Updated nick for UUID: {} ({})", (Object)playerUUID, (Object)playerNick);
                                }
                            }
                        }
                        catch (Exception e) {
                            PlayerStatistics.LOGGER.error("Error fetching/updating nick for UUID: {}", (Object)playerUUID);
                        }
                    });
                }
            }
            catch (SQLException e) {
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                }
                PlayerStatistics.LOGGER.error("Error fetching missing player nicks: {}", (Object)e.getMessage());
            }
            executor.shutdown();
            if (!executor.awaitTermination(3L, TimeUnit.MINUTES)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Executor interrupted (missing nicks): {}", (Object)e.getMessage());
        }
    }

    public static int getOrInsertPlayerId(Connection connection, UUID playerUUID, Timestamp lastOnline) throws SQLException {
        block37: {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Getting/Inserting player ID for UUID: {}", (Object)playerUUID);
            }
            String selectSQL = "SELECT id FROM uuid_map WHERE player_uuid = ?";
            try (PreparedStatement selectStmt = connection.prepareStatement(selectSQL);){
                selectStmt.setString(1, playerUUID.toString());
                try (ResultSet rs = selectStmt.executeQuery();){
                    if (!rs.next()) break block37;
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Player ID found for UUID: {}", (Object)playerUUID);
                    }
                    int playerId = rs.getInt("id");
                    String updateSQL = "UPDATE uuid_map SET player_last_online = ? WHERE id = ?";
                    try (PreparedStatement updateStmt = connection.prepareStatement(updateSQL);){
                        updateStmt.setTimestamp(1, lastOnline);
                        updateStmt.setInt(2, playerId);
                        updateStmt.executeUpdate();
                    }
                    int n = playerId;
                    return n;
                }
            }
        }
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Player ID not found for UUID: {} (insert)", (Object)playerUUID);
        }
        String insertSQL = "INSERT INTO uuid_map (player_uuid, player_last_online) VALUES (?, ?)";
        try (PreparedStatement insertStmt = connection.prepareStatement(insertSQL, 1);){
            insertStmt.setString(1, playerUUID.toString());
            insertStmt.setTimestamp(2, lastOnline);
            insertStmt.executeUpdate();
            try (ResultSet rs = insertStmt.getGeneratedKeys();){
                if (rs.next()) {
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Player ID inserted for UUID: {}", (Object)playerUUID);
                    }
                    int n = rs.getInt(1);
                    return n;
                }
            }
        }
        throw new SQLException("Failed to insert or retrieve player ID for UUID: " + String.valueOf(playerUUID));
    }

    /*
     * Exception decompiling
     */
    public static Timestamp getLastSyncTime(Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void updateSyncMetadata(Connection connection, String serverName, String serverDescription, String serverUrl, byte[] serverIcon) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Updating sync metadata ...");
        }
        String sql = "UPDATE sync_metadata SET last_update = ?, server_name = ?, server_desc = ?, server_url = ?, server_icon = ?";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Updating sync metadata (statement) ...");
            }
            Timestamp now = Timestamp.valueOf(LocalDateTime.now());
            String dbType = ConfigUtils.config.getString("database.type");
            if ("LOCAL".equals(DB_LOCATION)) {
                dbType = "SQLITE";
            }
            if ("SQLITE".equals(dbType)) {
                String isoTime = now.toLocalDateTime().toString();
                statement.setString(1, isoTime);
            } else {
                statement.setTimestamp(1, now);
            }
            statement.setString(2, serverName);
            statement.setString(3, serverDescription);
            statement.setString(4, serverUrl);
            statement.setBytes(5, serverIcon);
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Executing update statement ...");
            }
            statement.executeUpdate();
            StatSyncTask.lastSync = String.valueOf(now).split("\\.")[0];
        }
        catch (Exception e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error updating sync metadata: {}", (Object)e.getMessage());
        }
    }

    public static void updatePlayerNickInDatabase(Connection connection, int playerId, String playerNick) throws SQLException {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Updating player nick in database ...");
        }
        String updateSQL = "UPDATE uuid_map SET player_nick = ? WHERE id = ?";
        try (PreparedStatement updateStmt = connection.prepareStatement(updateSQL);){
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Updating player nick in database (statement) ...");
            }
            updateStmt.setString(1, playerNick);
            updateStmt.setInt(2, playerId);
            updateStmt.executeUpdate();
            ++StatSyncTask.progressFrom;
        }
    }

    public static void syncPlayerStats(Connection connection, UUID playerUUID, Timestamp lastOnline, JsonNode stats) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Synchronizing player stats ...");
        }
        try {
            int playerId = DatabaseUtils.getOrInsertPlayerId(connection, playerUUID, lastOnline);
            HashMap<String, List> batchStatements = new HashMap<String, List>();
            Iterator it = stats.fieldNames();
            while (it.hasNext()) {
                String statType = (String)it.next();
                JsonNode statDetails = stats.get(statType);
                String tableName2 = "`" + statType.replace("minecraft:", "") + "`";
                List statements2 = batchStatements.computeIfAbsent(tableName2, k -> new ArrayList());
                statDetails.fields().forEachRemaining(entry -> {
                    String statName = (String)entry.getKey();
                    int amount = ((JsonNode)entry.getValue()).asInt();
                    statements2.add(String.format("(%d, '%s', %d)", playerId, statName.replace("minecraft:", ""), amount));
                });
            }
            String dbType = ConfigUtils.config.getString("database.type");
            if ("LOCAL".equals(DB_LOCATION)) {
                dbType = "SQLITE";
            }
            String finalDbType = dbType;
            batchStatements.forEach((tableName, statements) -> {
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Synchronizing player stats ({}) - {} / {} ...", new Object[]{finalDbType, tableName, statements});
                }
                String string = finalDbType;
                int n = 0;
                String sql = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"MARIADB", "MYSQL", "SQLITE", "POSTGRESQL"}, (Object)string, n)) {
                    case 0, 1 -> "    INSERT INTO %s (player_id, stat_name, amount)\n    VALUES %s\n    ON DUPLICATE KEY UPDATE amount = VALUES(amount)\n".formatted(tableName, String.join((CharSequence)", ", statements));
                    case 2 -> "    INSERT INTO %s (player_id, stat_name, amount)\n    VALUES %s\n    ON CONFLICT(player_id, stat_name) DO UPDATE SET amount = excluded.amount\n".formatted(tableName, String.join((CharSequence)", ", statements));
                    case 3 -> "    INSERT INTO %s (player_id, stat_name, amount)\n    VALUES %s\n    ON CONFLICT (player_id, stat_name) DO UPDATE SET amount = excluded.amount\n".formatted(tableName, String.join((CharSequence)", ", statements));
                    default -> throw new IllegalArgumentException("Unsupported database type: " + finalDbType);
                };
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Executing batch statement ...");
                    }
                    statement.executeUpdate();
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Batch statement executed!");
                    }
                }
                catch (Exception e) {
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                    }
                    PlayerStatistics.LOGGER.error("Error executing batch statement: {}", (Object)e.getMessage());
                }
            });
            ++StatSyncTask.progressFrom;
        }
        catch (Exception e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error synchronizing player stats: {}", (Object)e.getMessage());
        }
    }

    private static String fetchBedrockPlayerNickFromAPI(String playerUUID) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Fetching Bedrock player nick from API ...");
        }
        playerUUID = playerUUID.substring(19).replace("-", "");
        long playerLong = Long.parseLong(playerUUID, 16);
        String apiUrl = "https://api.geysermc.org/v2/xbox/gamertag/" + playerLong;
        URI uri = new URI(apiUrl);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod("GET");
        Scanner scanner = new Scanner(connection.getInputStream());
        try {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Reading response from API (Bedrock) ...");
            }
            String response = scanner.useDelimiter("\\A").next();
            JsonNode rootNode = StatSyncTask.MAPPER.readTree(response);
            JsonNode profileNameNode = rootNode.get("gamertag");
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Player nick fetched from API (Bedrock): {}", (Object)profileNameNode.asText());
            }
            String string = profileNameNode != null ? profileNameNode.asText() : null;
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                }
                PlayerStatistics.LOGGER.error("Error fetching player nick from API (Bedrock): {}", (Object)e.getMessage());
                return null;
            }
        }
    }

    private static String fetchJavaPlayerNickFromAPI(String playerUUID) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Fetching Java player nick from API ...");
        }
        String apiUrl = "https://api.minetools.eu/profile/" + playerUUID;
        URI uri = new URI(apiUrl);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod("GET");
        Scanner scanner = new Scanner(connection.getInputStream());
        try {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Reading response from API (Java) ...");
            }
            String response = scanner.useDelimiter("\\A").next();
            JsonNode rootNode = StatSyncTask.MAPPER.readTree(response);
            JsonNode decodedNode = rootNode.get("decoded");
            JsonNode profileNameNode = decodedNode.get("profileName");
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Player nick fetched from API (Java): {}", (Object)profileNameNode.asText());
            }
            String string = profileNameNode != null ? profileNameNode.asText() : null;
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                }
                PlayerStatistics.LOGGER.error("Error fetching player nick from API (Java): {}", (Object)e.getMessage());
                return null;
            }
        }
    }

    public static void updatePositionsForTable(Connection connection) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Updating positions in tables ...");
        }
        StatSyncTask.progressTo = TABLE_NAMES.size();
        int sync_thread_count = "SQLITE".equalsIgnoreCase(DB_TYPE) ? 1 : ConfigUtils.config.getInt("sync-thread-count");
        try (ExecutorService executor = Executors.newFixedThreadPool(sync_thread_count);){
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Executor created (positions)");
            }
            PlayerStatistics.executors.add(executor);
            for (String tableName : TABLE_NAMES) {
                executor.submit(() -> {
                    block17: {
                        if (PlayerStatistics.DEBUG) {
                            PlayerStatistics.LOGGER.info("Executor running (positions)");
                        }
                        try {
                            String resetPositionsSQL = "UPDATE " + tableName + " SET position = NULL";
                            try (PreparedStatement resetStmt = connection.prepareStatement(resetPositionsSQL);){
                                if (PlayerStatistics.DEBUG) {
                                    PlayerStatistics.LOGGER.info("Resetting positions in table: {}", (Object)tableName);
                                }
                                resetStmt.executeUpdate();
                                if (PlayerStatistics.DEBUG) {
                                    PlayerStatistics.LOGGER.info("Positions reset in table: {}", (Object)tableName);
                                }
                            }
                            if ("MYSQL".equalsIgnoreCase(DB_TYPE) || "MARIADB".equalsIgnoreCase(DB_TYPE)) {
                                DatabaseUtils.updatePositionsMySQL(connection, tableName);
                                if (PlayerStatistics.DEBUG) {
                                    PlayerStatistics.LOGGER.info("Positions updated in table (MySQL/MARIADB): {}", (Object)tableName);
                                }
                                break block17;
                            }
                            if ("SQLITE".equalsIgnoreCase(DB_TYPE)) {
                                DatabaseUtils.updatePositionsSQLite(connection, tableName);
                                if (PlayerStatistics.DEBUG) {
                                    PlayerStatistics.LOGGER.info("Positions updated in table (SQLite): {}", (Object)tableName);
                                }
                                break block17;
                            }
                            throw new UnsupportedOperationException("Unsupported database type: " + DB_TYPE);
                        }
                        catch (SQLException e) {
                            if (PlayerStatistics.DEBUG) {
                                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
                            }
                            PlayerStatistics.LOGGER.error("Error updating positions in table '{}': {}", (Object)tableName, (Object)e.getMessage());
                        }
                    }
                });
            }
            executor.shutdown();
            if (!executor.awaitTermination(3L, TimeUnit.MINUTES)) {
                executor.shutdown();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Executor interrupted (positions): {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePositionsMySQL(Connection connection, String tableName) throws SQLException {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Updating positions in table (MySQL/MariaDB): {}", (Object)tableName);
        }
        String tempTableName = "ranked_data_" + Thread.currentThread().threadId();
        String createTempTableSQL = "    CREATE TEMPORARY TABLE %s AS\n    SELECT\n        player_id,\n        stat_name,\n        ROW_NUMBER() OVER (PARTITION BY stat_name ORDER BY amount DESC) AS row_num\n    FROM %s\n    WHERE amount > 0\n".formatted(tempTableName, tableName);
        String updatePositionsSQL = "    UPDATE %s\n    JOIN %s\n    ON %s.player_id = %s.player_id\n    AND %s.stat_name = %s.stat_name\n    SET %s.position = %s.row_num\n    WHERE %s.row_num <= 5\n".formatted(tableName, tempTableName, tableName, tempTableName, tableName, tempTableName, tableName, tempTableName, tempTableName);
        String dropTempTableSQL = "DROP TEMPORARY TABLE " + tempTableName;
        try {
            try (PreparedStatement createTempStmt = connection.prepareStatement(createTempTableSQL);){
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Creating temporary table (MySQL/MariaDB)...");
                }
                createTempStmt.executeUpdate();
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Temporary table created (MySQL/MariaDB)!");
                }
            }
            try (PreparedStatement updateStmt = connection.prepareStatement(updatePositionsSQL);){
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Updating positions in table (MySQL/MariaDB)...");
                }
                updateStmt.executeUpdate();
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Positions updated in table (MySQL/MariaDB)!");
                }
            }
        }
        finally {
            try (PreparedStatement dropTempStmt = connection.prepareStatement(dropTempTableSQL);){
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Dropping temporary table (MySQL/MariaDB)...");
                }
                dropTempStmt.executeUpdate();
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Temporary table dropped (MySQL/MariaDB)!");
                }
            }
        }
        ++StatSyncTask.progressFrom;
    }

    private static void updatePositionsSQLite(Connection connection, String tableName) throws SQLException {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Updating positions in table (SQLite): {}", (Object)tableName);
        }
        String updatePositionsSQL = "    WITH ranked_data_cte AS (\n        SELECT\n            player_id,\n            stat_name,\n            ROW_NUMBER() OVER (PARTITION BY stat_name ORDER BY amount DESC) AS row_num\n        FROM %s\n        WHERE amount > 0\n    )\n    UPDATE %s\n    SET position = (\n        SELECT row_num\n        FROM ranked_data_cte\n        WHERE ranked_data_cte.player_id = %s.player_id\n          AND ranked_data_cte.stat_name = %s.stat_name\n          AND ranked_data_cte.row_num <= 5\n    )\n    WHERE EXISTS (\n        SELECT 1\n        FROM ranked_data_cte\n        WHERE ranked_data_cte.player_id = %s.player_id\n          AND ranked_data_cte.stat_name = %s.stat_name\n          AND ranked_data_cte.row_num <= 5\n    )\n".formatted(tableName, tableName, tableName, tableName, tableName, tableName);
        try (PreparedStatement updateStmt = connection.prepareStatement(updatePositionsSQL);){
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Updating positions in table (SQLite)...");
            }
            updateStmt.executeUpdate();
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Positions updated in table (SQLite)!");
            }
        }
        ++StatSyncTask.progressFrom;
    }

    public static void populateHallOfFame(Connection connection) {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Populating Hall of Fame ...");
        }
        try {
            String clearHallOfFameSQL = "SQLITE".equalsIgnoreCase(DB_TYPE) ? "DELETE FROM hall_of_fame" : "TRUNCATE TABLE hall_of_fame";
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("SQL: {}", (Object)clearHallOfFameSQL);
            }
            try (PreparedStatement clearStmt = connection.prepareStatement(clearHallOfFameSQL);){
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Clearing Hall of Fame ...");
                }
                clearStmt.executeUpdate();
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Hall of Fame cleared!");
                }
            }
            String scoreCalculationSQL = DatabaseUtils.generateScoreCalculationSQL();
            try (PreparedStatement scoreStmt = connection.prepareStatement(scoreCalculationSQL);
                 ResultSet rs = scoreStmt.executeQuery();){
                if (PlayerStatistics.DEBUG) {
                    PlayerStatistics.LOGGER.info("Calculating player scores ...");
                }
                String insertHallOfFameSQL = "    INSERT INTO hall_of_fame (player_id, first_place, second_place, third_place, fourth_place, fifth_place, score)\n    VALUES (?, ?, ?, ?, ?, ?, ?)\n";
                try (PreparedStatement insertStmt = connection.prepareStatement(insertHallOfFameSQL);){
                    while (rs.next()) {
                        if (PlayerStatistics.DEBUG) {
                            PlayerStatistics.LOGGER.info("Inserting player into Hall of Fame: {}", (Object)rs.getInt("player_id"));
                        }
                        insertStmt.setInt(1, rs.getInt("player_id"));
                        insertStmt.setInt(2, rs.getInt("first_place"));
                        insertStmt.setInt(3, rs.getInt("second_place"));
                        insertStmt.setInt(4, rs.getInt("third_place"));
                        insertStmt.setInt(5, rs.getInt("fourth_place"));
                        insertStmt.setInt(6, rs.getInt("fifth_place"));
                        insertStmt.setInt(7, rs.getInt("score"));
                        insertStmt.addBatch();
                    }
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Executing batch insert ...");
                    }
                    insertStmt.executeBatch();
                    if (PlayerStatistics.DEBUG) {
                        PlayerStatistics.LOGGER.info("Batch insert executed!");
                    }
                }
            }
        }
        catch (SQLException e) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Trace: ", (Throwable)e);
            }
            PlayerStatistics.LOGGER.error("Error populating Hall of Fame: {}", (Object)e.getMessage());
        }
    }

    private static String generateScoreCalculationSQL() {
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Generating score calculation SQL ...");
        }
        StringBuilder unionQueries = new StringBuilder();
        for (String tableName : TABLE_NAMES) {
            if (PlayerStatistics.DEBUG) {
                PlayerStatistics.LOGGER.info("Generating score calculation SQL for table: {}", (Object)tableName);
            }
            if (!unionQueries.isEmpty()) {
                unionQueries.append(" UNION ALL ");
            }
            unionQueries.append("    SELECT\n        player_id,\n        CASE WHEN position = 1 THEN 10 ELSE 0 END AS first_place,\n        CASE WHEN position = 2 THEN 5 ELSE 0 END AS second_place,\n        CASE WHEN position = 3 THEN 3 ELSE 0 END AS third_place,\n        CASE WHEN position = 4 THEN 2 ELSE 0 END AS fourth_place,\n        CASE WHEN position = 5 THEN 1 ELSE 0 END AS fifth_place\n    FROM %s\n    WHERE position BETWEEN 1 AND 5\n".formatted(tableName));
        }
        if (PlayerStatistics.DEBUG) {
            PlayerStatistics.LOGGER.info("Generated SQL: {}", (Object)unionQueries);
        }
        return "    SELECT\n        player_id,\n        SUM(first_place) AS first_place,\n        SUM(second_place) AS second_place,\n        SUM(third_place) AS third_place,\n        SUM(fourth_place) AS fourth_place,\n        SUM(fifth_place) AS fifth_place,\n        SUM(first_place + second_place + third_place + fourth_place + fifth_place) AS score\n    FROM (\n        %s\n    ) AS all_stats\n    GROUP BY player_id\n    ORDER BY score DESC\n".formatted(unionQueries.toString());
    }
}

