/*
 * Decompiled with CFR 0.152.
 */
package github.fnewell.playerstatistics.webserver;

import github.fnewell.playerstatistics.PlayerStatistics;
import github.fnewell.playerstatistics.utils.ConfigUtils;
import io.javalin.Javalin;
import io.javalin.http.staticfiles.Location;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class WebServer {
    private static Javalin app;

    public static void startServer() {
        int port = ConfigUtils.config.getInt("web-server.port");
        app = Javalin.create(config -> {
            config.showJavalinBanner = false;
            config.staticFiles.add("/webpage", Location.CLASSPATH);
        }).start(port);
        PlayerStatistics.LOGGER.info("Web server running on port {}", (Object)port);
        app.get("/player-statistics.db", ctx -> {
            Path dbPath = FabricLoader.getInstance().getGameDir().resolve("mods/player-statistics/player-statistics.db");
            if (Files.exists(dbPath, new LinkOption[0])) {
                ctx.contentType("application/octet-stream");
                ctx.result(Files.newInputStream(dbPath, new OpenOption[0]));
            } else {
                ctx.status(404).result("File not found");
            }
        });
    }

    public static void stopServer() {
        if (app != null) {
            app.stop();
            PlayerStatistics.LOGGER.info("Web server stopped");
        }
    }
}

