/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.randomisfits.init.mixin;

import com.jahirtrap.randomisfits.init.ModConfig;
import com.jahirtrap.randomisfits.item.BaseLumberaxeItem;
import com.jahirtrap.randomisfits.util.RangeItem;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public abstract class ServerPlayerGameModeMixin {
    @Shadow
    protected ServerLevel level;
    @Final
    @Shadow
    protected ServerPlayer player;
    @Unique
    private Direction direction;
    @Unique
    private final List<BlockPos> destroyedBlocks = new CopyOnWriteArrayList<BlockPos>();
    @Unique
    private final List<BlockPos> rangeBlocks = new CopyOnWriteArrayList<BlockPos>();
    @Unique
    private final List<BlockPos> fellingBlocks = new CopyOnWriteArrayList<BlockPos>();

    @Inject(method={"handleBlockBreakAction"}, at={@At(value="HEAD")})
    private void getDirection(BlockPos blockPos, ServerboundPlayerActionPacket.Action action, Direction direction, int i, int j, CallbackInfo ci) {
        this.direction = direction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")})
    public void destroyBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = this.player.getMainHandItem();
        BlockState state = this.level.getBlockState(pos);
        Block block = state.getBlock();
        Object object = stack.getItem();
        if (object instanceof RangeItem) {
            RangeItem rangeItem = (RangeItem)object;
            if (stack.isCorrectToolForDrops(state) && rangeItem.enableRange(stack)) {
                if (!this.rangeBlocks.isEmpty()) return;
                this.getRangeBlocks(pos, this.direction, stack, rangeItem.getRange());
                for (BlockPos targetPos : this.rangeBlocks) {
                    if (stack.getDamageValue() >= stack.getMaxDamage()) {
                        this.rangeBlocks.clear();
                        return;
                    }
                    this.player.gameMode.destroyBlock(targetPos);
                    this.rangeBlocks.remove(targetPos);
                }
                return;
            }
        }
        if (!((object = stack.getItem()) instanceof BaseLumberaxeItem)) return;
        BaseLumberaxeItem lumberaxeItem = (BaseLumberaxeItem)((Object)object);
        if (!stack.isCorrectToolForDrops(state) || !lumberaxeItem.enableFelling(stack) || block instanceof BonemealableBlock || block instanceof VineBlock || block instanceof SugarCaneBlock || block instanceof HangingRootsBlock || block instanceof BushBlock || block instanceof SporeBlossomBlock || block instanceof ScaffoldingBlock) return;
        this.getFellingBlocks(pos, stack);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        int i = 0;
        if (!this.fellingBlocks.isEmpty()) {
            for (BlockPos targetPos : this.fellingBlocks) {
                if (this.player.getMainHandItem().getDamageValue() >= this.player.getMainHandItem().getMaxDamage()) {
                    this.fellingBlocks.clear();
                    break;
                }
                this.player.gameMode.destroyBlock(targetPos);
                this.fellingBlocks.remove(targetPos);
                if (i++ <= 32) continue;
                break;
            }
            if (this.destroyedBlocks.size() > ModConfig.fellingLimit) {
                this.fellingBlocks.clear();
            }
            if (this.fellingBlocks.isEmpty()) {
                this.destroyedBlocks.clear();
            }
        }
    }

    @Unique
    private void getRangeBlocks(BlockPos pos, Direction direction, ItemStack stack, int range) {
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                BlockPos targetPos = pos;
                switch (direction) {
                    case DOWN: 
                    case UP: {
                        targetPos = pos.offset(i, 0, j);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        targetPos = pos.offset(i, j, 0);
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        targetPos = pos.offset(0, i, j);
                    }
                }
                BlockState targetState = this.level.getBlockState(targetPos);
                if (!stack.isCorrectToolForDrops(targetState) || this.rangeBlocks.contains(targetPos)) continue;
                this.rangeBlocks.add(targetPos);
            }
        }
    }

    @Unique
    private void getFellingBlocks(BlockPos pos, ItemStack stack) {
        this.destroyedBlocks.add(pos);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    BlockPos targetPos = pos.offset(i, j, k);
                    BlockState targetState = this.level.getBlockState(targetPos);
                    Block targetBlock = targetState.getBlock();
                    if (!stack.isCorrectToolForDrops(targetState) || targetBlock instanceof BonemealableBlock || targetBlock instanceof VineBlock || targetBlock instanceof SugarCaneBlock || targetBlock instanceof HangingRootsBlock || targetBlock instanceof BushBlock || targetBlock instanceof SporeBlossomBlock || targetBlock instanceof ScaffoldingBlock || this.fellingBlocks.contains(targetPos) || this.destroyedBlocks.contains(targetPos)) continue;
                    this.fellingBlocks.add(targetPos);
                }
            }
        }
    }
}

