/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.randomisfits.item;

import com.jahirtrap.randomisfits.init.ModConfig;
import com.jahirtrap.randomisfits.util.CommonUtils;
import com.jahirtrap.randomisfits.util.RangeItem;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class BaseHammerItem
extends Item
implements RangeItem {
    public BaseHammerItem(ToolMaterial material, Item.Properties properties) {
        super(properties.pickaxe(material, 7.0f, -3.0f));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ModConfig.toggleHammerMode && !level.isClientSide() && player.isSecondaryUseActive()) {
            this.setMode(stack, !this.getMode(stack));
            player.displayClientMessage(CommonUtils.coloredTextComponent(this.getModeText(this.getMode(stack)), ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        if (ModConfig.toggleHammerMode) {
            tooltip.accept(CommonUtils.coloredTextComponent(this.getModeText(this.getMode(stack)), ChatFormatting.GRAY));
        }
    }

    public int getBarColor(ItemStack stack) {
        return CommonUtils.blueBar(stack);
    }

    @Override
    public boolean enableRange(ItemStack stack) {
        if (!ModConfig.toggleHammerMode) {
            return true;
        }
        return this.getMode(stack);
    }
}

