/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.randomisfits.item;

import com.jahirtrap.randomisfits.util.CommonUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class BaseRepairKitItem
extends Item {
    private final int amount;

    public BaseRepairKitItem(int repairAmount, Item.Properties properties) {
        super(properties.stacksTo(16));
        this.amount = repairAmount;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack kit = player.getItemInHand(hand);
        ItemStack item = player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (!level.isClientSide() && BaseRepairKitItem.attemptRepair(level, player, kit, item, this.amount)) {
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        tooltip.accept(CommonUtils.coloredTextComponent(Component.translatable((String)"randomisfits.repair_kit.amount").getString() + CommonUtils.formatText(this.amount), ChatFormatting.GRAY));
    }

    private static boolean attemptRepair(Level level, Player player, ItemStack kit, ItemStack item, int amount) {
        if (item.isDamaged()) {
            item.setDamageValue(item.getDamageValue() - amount);
            if (!player.getAbilities().instabuild) {
                kit.shrink(1);
            }
            level.playSound(null, player.blockPosition(), SoundEvents.ANVIL_USE, SoundSource.PLAYERS);
            return true;
        }
        return false;
    }
}

