/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.randomisfits.init;

import com.jahirtrap.randomisfits.init.ModTags;
import java.util.EnumMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.neoforged.neoforge.common.Tags;

public class ModMaterials {

    public static interface Tool {
        public static final ToolMaterial ZURITE = new ToolMaterial(BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 1320, 8.5f, 4.0f, 16, ModTags.Items.ZURITE_INGOTS);
        public static final ToolMaterial STEEL = new ToolMaterial(BlockTags.INCORRECT_FOR_IRON_TOOL, 501, 6.5f, 2.0f, 14, ModTags.Items.STEEL_INGOTS);
        public static final ToolMaterial BRONZE = new ToolMaterial(BlockTags.INCORRECT_FOR_IRON_TOOL, 350, 7.0f, 2.0f, 16, ModTags.Items.BRONZE_INGOTS);
        public static final ToolMaterial ENDERITE = new ToolMaterial(BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 4096, 15.0f, 5.0f, 17, ModTags.Items.ENDERITE_INGOTS);
        public static final ToolMaterial COPPER_HARD = Tool.copy(ToolMaterial.COPPER, 2, 0.0f);
        public static final ToolMaterial IRON_HARD = Tool.copy(ToolMaterial.IRON, 2, 0.0f);
        public static final ToolMaterial GOLD_HARD = Tool.copy(ToolMaterial.GOLD, 10, 0.0f);
        public static final ToolMaterial DIAMOND_HARD = Tool.copy(ToolMaterial.DIAMOND, 2, 0.0f);
        public static final ToolMaterial NETHERITE_HARD = Tool.copy(ToolMaterial.NETHERITE, 2, 0.0f);
        public static final ToolMaterial ZURITE_HARD = Tool.copy(ZURITE, 2, 0.0f);
        public static final ToolMaterial STEEL_HARD = Tool.copy(STEEL, 2, 0.0f);
        public static final ToolMaterial BRONZE_HARD = Tool.copy(BRONZE, 2, 0.0f);
        public static final ToolMaterial ENDERITE_HARD = Tool.copy(ENDERITE, 2, 0.0f);

        private static ToolMaterial copy(ToolMaterial material, int i, float j) {
            return new ToolMaterial(material.incorrectBlocksForDrops(), material.durability() * i, material.speed() + j, material.attackDamageBonus(), material.enchantmentValue(), material.repairItems());
        }
    }

    public static interface Armor {
        public static final ArmorMaterial INVISIBLE = new ArmorMaterial(15, Armor.createMap(new int[]{2, 5, 6, 2, 5}), 9, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, Tags.Items.GLASS_BLOCKS_COLORLESS, Armor.createAsset("invisible"));
        public static final ArmorMaterial REINFORCED_INVISIBLE = new ArmorMaterial(30, Armor.createMap(new int[]{3, 6, 8, 3, 11}), 10, SoundEvents.ARMOR_EQUIP_GENERIC, 2.0f, 0.0f, Tags.Items.GLASS_BLOCKS_COLORLESS, Armor.createAsset("reinforced_invisible"));

        private static EnumMap<ArmorType, Integer> createMap(int[] values) {
            EnumMap<ArmorType, Integer> enumMap = new EnumMap<ArmorType, Integer>(ArmorType.class);
            for (int i = 0; i < values.length; ++i) {
                enumMap.put(ArmorType.values()[i], values[i]);
            }
            return enumMap;
        }

        private static ResourceKey<EquipmentAsset> createAsset(String name) {
            return ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"randomisfits", (String)name));
        }
    }
}

