/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.randomisfits.item;

import com.jahirtrap.randomisfits.init.ModComponents;
import com.jahirtrap.randomisfits.init.ModConfig;
import com.jahirtrap.randomisfits.util.CommonUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class BaseLumberaxeItem
extends AxeItem {
    private static final DataComponentType<Boolean> FELLING_KEY = (DataComponentType)ModComponents.FELLING_KEY.get();

    public BaseLumberaxeItem(ToolMaterial material, Item.Properties properties) {
        super(material, 6.0f, -3.0f, properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ModConfig.toggleLumberaxeFelling && !level.isClientSide() && player.isSecondaryUseActive()) {
            this.setMode(stack, !this.getMode(stack));
            player.displayClientMessage(CommonUtils.coloredTextComponent(this.getModeText(this.getMode(stack)), ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        if (ModConfig.toggleLumberaxeFelling) {
            tooltip.accept(CommonUtils.coloredTextComponent(this.getModeText(this.getMode(stack)), ChatFormatting.GRAY));
        }
    }

    public int getBarColor(ItemStack stack) {
        return CommonUtils.blueBar(stack);
    }

    boolean getMode(ItemStack stack) {
        if (!stack.getComponents().has(FELLING_KEY)) {
            this.setMode(stack, true);
        }
        return (Boolean)stack.getOrDefault(FELLING_KEY, (Object)true);
    }

    private void setMode(ItemStack stack, Boolean range) {
        stack.set(FELLING_KEY, (Object)range);
    }

    private String getModeText(Boolean felling) {
        String mode = felling != false ? Component.translatable((String)"randomisfits.lumberaxe.felling.yes").getString() : Component.translatable((String)"randomisfits.lumberaxe.felling.no").getString();
        return mode;
    }

    public boolean enableFelling(ItemStack stack) {
        if (!ModConfig.toggleLumberaxeFelling) {
            return true;
        }
        return this.getMode(stack);
    }
}

