/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.randomisfits.item;

import com.jahirtrap.randomisfits.init.ModComponents;
import com.jahirtrap.randomisfits.init.ModConfig;
import com.jahirtrap.randomisfits.init.ModTags;
import com.jahirtrap.randomisfits.util.CommonUtils;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class BaseMultitoolItem
extends Item {
    private static final Item[] items = new Item[]{Items.WOODEN_AXE, Items.WOODEN_PICKAXE, Items.WOODEN_SHOVEL, Items.WOODEN_HOE};
    private static final DataComponentType<String> MODE_KEY = (DataComponentType)ModComponents.MODE_KEY.get();
    private static final String SHOVEL_MODE = "shovel";
    private static final String HOE_MODE = "hoe";

    public BaseMultitoolItem(ToolMaterial material, Item.Properties properties) {
        super(properties.tool(material, ModTags.Blocks.MINEABLE_WITH_MULTITOOL, 6.0f, -3.0f, 0.0f));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (ModConfig.multitoolInteractions && !level.isClientSide() && player.isSecondaryUseActive()) {
            String mode = this.getMode(stack);
            mode = Objects.equals(mode, SHOVEL_MODE) ? HOE_MODE : SHOVEL_MODE;
            this.setMode(stack, mode);
            player.displayClientMessage(CommonUtils.coloredTextComponent(this.getModeText(mode), ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        if (ModConfig.multitoolInteractions) {
            tooltip.accept(CommonUtils.coloredTextComponent(this.getModeText(this.getMode(stack)), ChatFormatting.GRAY));
        }
    }

    public int getBarColor(ItemStack stack) {
        return CommonUtils.blueBar(stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!ModConfig.multitoolInteractions) {
            return InteractionResult.PASS;
        }
        InteractionResult result = items[0].useOn(context);
        if (result == InteractionResult.PASS && (result = items[1].useOn(context)) == InteractionResult.PASS) {
            result = items[this.getMode(context.getItemInHand()).equals(SHOVEL_MODE) ? 2 : 3].useOn(context);
        }
        return result;
    }

    private String getMode(ItemStack stack) {
        if (!stack.getComponents().has(MODE_KEY)) {
            this.setMode(stack, SHOVEL_MODE);
        }
        return (String)stack.getOrDefault(MODE_KEY, (Object)SHOVEL_MODE);
    }

    private void setMode(ItemStack stack, String mode) {
        stack.set(MODE_KEY, (Object)mode);
    }

    private String getModeText(String mode) {
        mode = Objects.equals(mode, HOE_MODE) ? Component.translatable((String)"randomisfits.multitool.mode.hoe").getString() : Component.translatable((String)"randomisfits.multitool.mode.shovel").getString();
        return mode;
    }
}

