/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.randomisfits.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseLightBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    private final float width;
    private final float height;

    public BaseLightBlock(float width, float height, BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.DESTROY).sound(SoundType.METAL).strength(0.5f).lightLevel($ -> 15));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.width = width;
        this.height = height;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(FACING);
        float a = (16.0f - this.width) / 2.0f;
        float b = 16.0f - a;
        float c = 0.0f + this.height;
        float d = 16.0f - c;
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> Block.box((double)a, (double)0.0, (double)a, (double)b, (double)c, (double)b);
            case Direction.DOWN -> Block.box((double)a, (double)d, (double)a, (double)b, (double)16.0, (double)b);
            case Direction.NORTH -> Block.box((double)a, (double)a, (double)d, (double)b, (double)b, (double)16.0);
            case Direction.SOUTH -> Block.box((double)a, (double)a, (double)0.0, (double)b, (double)b, (double)c);
            case Direction.WEST -> Block.box((double)d, (double)a, (double)a, (double)16.0, (double)b, (double)b);
            case Direction.EAST -> Block.box((double)0.0, (double)a, (double)a, (double)c, (double)b, (double)b);
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        Direction direction = context.getClickedFace();
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)direction)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return facing == ((Direction)state.getValue(FACING)).getOpposite() && !state.canSurvive(level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, tickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue(FACING);
        return BaseLightBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(direction.getOpposite()), (Direction)direction);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING, BlockStateProperties.WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

