/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.randomisfits.init;

import com.jahirtrap.randomisfits.block.BaseLightBlock;
import com.jahirtrap.randomisfits.init.ModConfig;
import com.jahirtrap.randomisfits.init.ModMaterials;
import com.jahirtrap.randomisfits.item.BaseExcavatorItem;
import com.jahirtrap.randomisfits.item.BaseGlassCutterItem;
import com.jahirtrap.randomisfits.item.BaseHammerItem;
import com.jahirtrap.randomisfits.item.BaseLumberaxeItem;
import com.jahirtrap.randomisfits.item.BaseMultitoolItem;
import com.jahirtrap.randomisfits.item.BaseRepairKitItem;
import com.jahirtrap.randomisfits.item.BaseWearableItem;
import com.jahirtrap.randomisfits.item.CraftingPlateItem;
import com.jahirtrap.randomisfits.item.EnderBagItem;
import com.jahirtrap.randomisfits.item.NetheriteLampItem;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModContent {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"randomisfits");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"randomisfits");
    public static final HashMap<RegistryObject<? extends ItemLike>, Integer> FUEL_ITEMS = new HashMap();
    public static final List<RegistryObject<Item>> INVISIBLE_ARMOR = ModContent.registerArmor(ModMaterials.Armor.INVISIBLE, new Item.Properties());
    public static final List<RegistryObject<Item>> REINFORCED_INVISIBLE_ARMOR = ModContent.registerArmor(ModMaterials.Armor.REINFORCED_INVISIBLE, new Item.Properties());
    public static final RegistryObject<Item> HANDLE = ModContent.registerItem("handle", Item::new, new Item.Properties());
    public static final List<RegistryObject<Item>> IRON_EXTRA_TOOLS = ModContent.registerExtraTools("iron", ToolMaterial.IRON, ModMaterials.Tool.IRON_HARD, new Item.Properties());
    public static final List<RegistryObject<Item>> GOLDEN_EXTRA_TOOLS = ModContent.registerExtraTools("golden", ToolMaterial.GOLD, ModMaterials.Tool.GOLD_HARD, new Item.Properties());
    public static final List<RegistryObject<Item>> DIAMOND_EXTRA_TOOLS = ModContent.registerExtraTools("diamond", ToolMaterial.DIAMOND, ModMaterials.Tool.DIAMOND_HARD, new Item.Properties());
    public static final List<RegistryObject<Item>> NETHERITE_EXTRA_TOOLS = ModContent.registerExtraTools("netherite", ToolMaterial.NETHERITE, ModMaterials.Tool.NETHERITE_HARD, new Item.Properties().fireResistant());
    public static final List<RegistryObject<Item>> ENDERITE_EXTRA_TOOLS = ModContent.registerExtraTools("enderite", ModMaterials.Tool.ENDERITE, ModMaterials.Tool.ENDERITE_HARD, new Item.Properties().fireResistant());
    public static final List<RegistryObject<Item>> STEEL_EXTRA_TOOLS = ModContent.registerExtraTools("steel", ModMaterials.Tool.STEEL, ModMaterials.Tool.STEEL_HARD, new Item.Properties());
    public static final List<RegistryObject<Item>> BRONZE_EXTRA_TOOLS = ModContent.registerExtraTools("bronze", ModMaterials.Tool.BRONZE, ModMaterials.Tool.BRONZE_HARD, new Item.Properties());
    public static final List<RegistryObject<Item>> ZURITE_EXTRA_TOOLS = ModContent.registerExtraTools("zurite", ModMaterials.Tool.ZURITE, ModMaterials.Tool.ZURITE_HARD, new Item.Properties().fireResistant());
    public static final RegistryObject<Item> IRON_REPAIR_KIT = ModContent.registerItem("iron_repair_kit", p -> new BaseRepairKitItem(ModConfig.ironKitRepairAmount, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> DIAMOND_REPAIR_KIT = ModContent.registerItem("diamond_repair_kit", p -> new BaseRepairKitItem(ModConfig.diamondKitRepairAmount, (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Item> NETHERITE_REPAIR_KIT = ModContent.registerItem("netherite_repair_kit", p -> new BaseRepairKitItem(ModConfig.netheriteKitRepairAmount, (Item.Properties)p), new Item.Properties().fireResistant());
    public static final RegistryObject<Item> CRAFTING_PLATE = ModContent.registerItem("crafting_plate", CraftingPlateItem::new, new Item.Properties());
    public static final RegistryObject<Item> ENDER_BAG = ModContent.registerItem("ender_bag", EnderBagItem::new, new Item.Properties());
    public static final RegistryObject<Block> BULB_BLOCK = ModContent.registerBlock("bulb", p -> new BaseLightBlock(4.0f, 2.0f, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of());
    public static final RegistryObject<Item> BULB = ModContent.registerItem("bulb", p -> new BaseWearableItem((Block)BULB_BLOCK.get(), (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Block> LAMP_BLOCK = ModContent.registerBlock("lamp", p -> new BaseLightBlock(8.0f, 2.0f, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of());
    public static final RegistryObject<Item> LAMP = ModContent.registerItem("lamp", p -> new BaseWearableItem((Block)LAMP_BLOCK.get(), (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Block> NETHERITE_LAMP_BLOCK = ModContent.registerBlock("netherite_lamp", p -> new BaseLightBlock(8.0f, 2.0f, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of());
    public static final RegistryObject<Item> NETHERITE_LAMP = ModContent.registerItem("netherite_lamp", p -> new NetheriteLampItem((Block)NETHERITE_LAMP_BLOCK.get(), (Item.Properties)p), new Item.Properties());
    public static final RegistryObject<Block> GLOW_CORE_BLOCK = ModContent.registerBlock("glow_core", p -> new BaseLightBlock(8.0f, 8.0f, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of());
    public static final RegistryObject<Item> GLOW_CORE = ModContent.registerItem("glow_core", p -> new BaseWearableItem((Block)GLOW_CORE_BLOCK.get(), (Item.Properties)p), new Item.Properties());

    private static RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp, Item.Properties itemProp) {
        RegistryObject<Block> blockReg = ModContent.registerBlock(name, function, blockProp);
        ModContent.registerItem(name, p -> new BlockItem((Block)blockReg.get(), p), itemProp.useBlockDescriptionPrefix());
        return blockReg;
    }

    private static RegistryObject<Block> registerBlock(String name, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockProp) {
        return BLOCKS.register(name, () -> (Block)function.apply(blockProp.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"randomisfits", (String)name)))));
    }

    private static RegistryObject<Item> registerItem(String name, Function<Item.Properties, Item> function, Item.Properties itemProp) {
        return ITEMS.register(name, () -> (Item)function.apply(itemProp.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"randomisfits", (String)name)))));
    }

    private static List<RegistryObject<Item>> registerTools(String name, ToolMaterial material, float[] attr, Item.Properties itemProp) {
        return List.of(ModContent.registerItem(name + "_sword", p -> new SwordItem(material, 3.0f, -2.4f, p), itemProp), ModContent.registerItem(name + "_pickaxe", p -> new PickaxeItem(material, 1.0f, -2.8f, p), itemProp), ModContent.registerItem(name + "_axe", p -> new AxeItem(material, attr[0], attr[1], p), itemProp), ModContent.registerItem(name + "_shovel", p -> new ShovelItem(material, 1.5f, -3.0f, p), itemProp), ModContent.registerItem(name + "_hoe", p -> new HoeItem(material, attr[2], attr[3], p), itemProp));
    }

    private static List<RegistryObject<Item>> registerExtraTools(String name, ToolMaterial material, ToolMaterial materialHard, Item.Properties itemProp) {
        return List.of(ModContent.registerItem(name + "_multitool", p -> new BaseMultitoolItem(materialHard, (Item.Properties)p), itemProp), ModContent.registerItem(name + "_hammer", p -> new BaseHammerItem(materialHard, (Item.Properties)p), itemProp), ModContent.registerItem(name + "_lumberaxe", p -> new BaseLumberaxeItem(materialHard, (Item.Properties)p), itemProp), ModContent.registerItem(name + "_excavator", p -> new BaseExcavatorItem(materialHard, (Item.Properties)p), itemProp), ModContent.registerItem(name + "_glass_cutter", p -> new BaseGlassCutterItem(material, (Item.Properties)p), itemProp));
    }

    private static List<RegistryObject<Item>> registerArmor(ArmorMaterial material, Item.Properties itemProp) {
        String name = material.assetId().location().getPath();
        return List.of(ModContent.registerItem(name + "_helmet", p -> new ArmorItem(material, ArmorType.HELMET, p), itemProp), ModContent.registerItem(name + "_chestplate", p -> new ArmorItem(material, ArmorType.CHESTPLATE, p), itemProp), ModContent.registerItem(name + "_leggings", p -> new ArmorItem(material, ArmorType.LEGGINGS, p), itemProp), ModContent.registerItem(name + "_boots", p -> new ArmorItem(material, ArmorType.BOOTS, p), itemProp));
    }

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        FUEL_ITEMS.put(HANDLE, 200);
        MinecraftForge.EVENT_BUS.addListener(event -> FUEL_ITEMS.forEach((item, burnTime) -> {
            if (item.get() == event.getItemStack().getItem()) {
                event.setBurnTime(burnTime.intValue());
            }
        }));
    }
}

