/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.index.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MenuBlockEntityCore
extends BlockEntity
implements MenuProvider {
    protected final String inventoryInputItemSaveKey = "index.inventory.in";
    protected final String inventoryOutputItemSaveKey = "index.inventory.out";
    protected final ItemStackHandler inputItems;
    protected final ItemStackHandler outputItems;

    public MenuBlockEntityCore(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int inputItemNumber, int outputItemNumber) {
        super(pType, pPos, pBlockState);
        this.inputItems = new ItemStackHandler(inputItemNumber){

            protected void onContentsChanged(int slot) {
                MenuBlockEntityCore.this.setChanged();
            }
        };
        this.outputItems = new ItemStackHandler(outputItemNumber){

            protected void onContentsChanged(int slot) {
                MenuBlockEntityCore.this.setChanged();
            }
        };
    }

    public ItemStack getInputSlotItem(int ind) {
        return this.getInputItemsHandler().getStackInSlot(ind);
    }

    public ItemStack getOutputSlotItem(int ind) {
        return this.getOutputItemsHandler().getStackInSlot(ind);
    }

    public ItemStackHandler getInputItemsHandler() {
        return this.inputItems;
    }

    public ItemStackHandler getOutputItemsHandler() {
        return this.outputItems;
    }

    @NotNull
    public abstract Component getDisplayName();

    @Nullable
    public abstract AbstractContainerMenu createMenu(int var1, @NotNull Inventory var2, @NotNull Player var3);

    public void onLoad() {
        super.onLoad();
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("index.inventory.in", (Tag)this.inputItems.serializeNBT(pRegistries));
        pTag.put("index.inventory.out", (Tag)this.outputItems.serializeNBT(pRegistries));
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.inputItems.deserializeNBT(pRegistries, pTag.getCompound("index.inventory.in"));
        this.outputItems.deserializeNBT(pRegistries, pTag.getCompound("index.inventory.out"));
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        this.loadAdditional(tag, holders);
    }
}

