/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.index.block.index;

import com.mojang.serialization.MapCodec;
import dev.anye.mc.index.block.EntityBlockCore;
import dev.anye.mc.index.block.index.IndexBlockEntity;
import dev.anye.mc.index.register.BlockEntityRegister;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexBlock
extends EntityBlockCore {
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public IndexBlock() {
        super(BlockBehaviour.Properties.of().destroyTime(10.0f).lightLevel(value -> 9).noOcclusion());
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ((ServerPlayer)pPlayer).openMenu(pState.getMenuProvider(pLevel, pPos), pPos);
        return InteractionResult.CONSUME;
    }

    private void openScreen(Level pLevel, BlockPos pPos, Player pPlayer) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof IndexBlockEntity) {
            IndexBlockEntity indexBlockEntity = (IndexBlockEntity)blockentity;
            ((ServerPlayer)pPlayer).openMenu((MenuProvider)indexBlockEntity, pPos);
            pPlayer.awardStat(Stats.ENCHANT_ITEM);
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new IndexBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide) {
            return null;
        }
        return IndexBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)BlockEntityRegister.INDEX.get()), (level, blockPos, blockState, blockEntityIndex) -> blockEntityIndex.tick(level, blockPos, blockState));
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        CustomData dat = (CustomData)pStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (dat != null) {
            CompoundTag nbt = dat.copyTag();
            int i = nbt.getList("index.enchants", 10).size();
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.index.index.save.all").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)String.valueOf(i)).withStyle(ChatFormatting.RED)));
            i = nbt.getInt("index.mp");
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.index.index.mp").withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)String.valueOf(i)).withStyle(ChatFormatting.DARK_AQUA)));
        }
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.index.index.item.desc").withStyle(ChatFormatting.DARK_BLUE));
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.index.index.item.desc1").withStyle(ChatFormatting.GOLD));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }
}

