/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.index.block.index;

import dev.anye.mc.index.block.MenuBlockEntityCore;
import dev.anye.mc.index.config.Config;
import dev.anye.mc.index.config.ConfigData;
import dev.anye.mc.index.datatype.IndexData;
import dev.anye.mc.index.datatype.IndexEnchantData;
import dev.anye.mc.index.register.BlockEntityRegister;
import dev.anye.mc.index.register.NetRegister;
import dev.anye.mc.index.screen.index.IndexMenu;
import dev.anye.mc.net.core.NetCore;
import dev.anye.mc.net.core.NetHandle;
import dev.anye.mc.net.core.NetPack;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexBlockEntity
extends MenuBlockEntityCore {
    private final String enchantDatSaveKey = "index.enchants";
    private final String progressSaveKey = "index.progress";
    private final String mpSaveKey = "index.mp";
    public static final BlockCapability<IItemHandler, @Nullable Direction> ITEM_HANDLER_BLOCK = BlockCapability.createSided((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"index", (String)"item_handler_index"), IItemHandler.class);
    private int progress = 0;
    private int maxProgress = 25;
    private int mp = 0;
    protected final ContainerData data;
    private final BlockPos blockPos;
    private Player player;
    private final IndexData enchantData = new IndexData(this.level);

    public IndexBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegister.INDEX.get(), pPos, pBlockState, 1, 1);
        this.blockPos = pPos;
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> IndexBlockEntity.this.progress;
                    case 1 -> IndexBlockEntity.this.maxProgress;
                    case 2 -> IndexBlockEntity.this.blockPos.getX();
                    case 3 -> IndexBlockEntity.this.blockPos.getY();
                    case 4 -> IndexBlockEntity.this.blockPos.getZ();
                    case 5 -> IndexBlockEntity.this.mp;
                    default -> 0;
                };
            }

            public void set(int i, int i1) {
                switch (i) {
                    case 0: {
                        IndexBlockEntity.this.progress = i1;
                        break;
                    }
                    case 1: {
                        IndexBlockEntity.this.maxProgress = i1;
                    }
                }
            }

            public int getCount() {
                return 6;
            }
        };
    }

    public void setLevel(@NotNull Level pLevel) {
        super.setLevel(pLevel);
        this.enchantData.setLevel(pLevel);
    }

    public IItemHandler getItemHandler(Direction direction) {
        if (direction == Direction.DOWN) {
            if (this.player != null && this.player.containerMenu instanceof IndexMenu) {
                return null;
            }
            return this.outputItems;
        }
        return this.inputItems;
    }

    public ItemStack getInputItem() {
        return this.getInputSlotItem(0);
    }

    public ItemStack getOutputItem() {
        return this.getOutputSlotItem(0);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean isDone() {
        return this.progress >= this.maxProgress;
    }

    private void addProgress() {
        ++this.progress;
    }

    public void drops() {
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.index.index");
    }

    @Override
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
        this.player = player;
        return new IndexMenu(i, inventory, this, this.data);
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(this.saveDat(pTag), pRegistries);
    }

    private CompoundTag saveDat(CompoundTag tag) {
        tag.put("index.enchants", (Tag)this.enchantData.formatEnchants());
        tag.putInt("index.progress", this.progress);
        tag.putInt("index.mp", this.mp);
        return tag;
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.loadDat(pTag, pRegistries);
    }

    private void loadDat(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.enchantData.loadEnchants(pRegistries, tag.getList("index.enchants", 10));
        this.progress = tag.getInt("index.progress");
        this.mp = tag.getInt("index.mp");
    }

    public CompoundTag getNetPack() {
        return this.saveDat(new CompoundTag());
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag dat = super.getUpdateTag(pRegistries);
        return this.saveDat(dat);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (this.addMP()) {
            return;
        }
        if (this.checkItem()) {
            this.addProgress();
            IndexBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
            if (this.isDone()) {
                this.outPutItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private boolean addMP() {
        int base = 0;
        if (this.getInputItem().getItem() == Items.LAPIS_LAZULI) {
            base = 1;
        } else if (this.getInputItem().getItem() == Items.LAPIS_BLOCK) {
            base = 9;
        }
        if (base > 0) {
            this.mp += this.getInputItem().getCount() * base;
            this.getInputItemsHandler().setStackInSlot(0, ItemStack.EMPTY);
            return true;
        }
        return false;
    }

    private void outPutItem() {
        ItemEnchantments ed;
        ItemStack inItem = this.getInputItem().copy();
        if (inItem.isEmpty() || inItem.getCount() < 1) {
            return;
        }
        ItemStack lOutItem = this.getOutputItem();
        if (!lOutItem.isEmpty() && lOutItem.getCount() >= lOutItem.getMaxStackSize()) {
            return;
        }
        if (inItem.is(Items.ENCHANTED_BOOK) && (lOutItem.is(Items.BOOK) || lOutItem.isEmpty())) {
            ed = (ItemEnchantments)inItem.get(DataComponents.STORED_ENCHANTMENTS);
            if (lOutItem.isEmpty()) {
                lOutItem = new ItemStack((ItemLike)Items.BOOK, 1);
            } else {
                lOutItem.setCount(lOutItem.getCount() + 1);
            }
        } else if (lOutItem.isEmpty()) {
            ed = inItem.getTagEnchantments();
            lOutItem = inItem.copy();
            lOutItem.setCount(1);
            lOutItem.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            lOutItem.set(DataComponents.REPAIR_COST, (Object)0);
        } else {
            ed = null;
        }
        if (ed == null) {
            return;
        }
        ed.keySet().forEach(enchantmentHolder -> this.enchantData.addEnchant((Holder<Enchantment>)enchantmentHolder, ed.getLevel(enchantmentHolder)));
        this.getInputItemsHandler().extractItem(0, 1, false);
        this.getOutputItemsHandler().setStackInSlot(0, lOutItem);
        this.updateToClient();
    }

    private boolean checkItem() {
        ItemStack in = this.getInputItem();
        if (in == ItemStack.EMPTY) {
            return false;
        }
        if (this.getOutputItem() != ItemStack.EMPTY) {
            return in.is(Items.ENCHANTED_BOOK) && this.getOutputItem().is(Items.BOOK);
        }
        if (this.getOutputItem() == ItemStack.EMPTY && in.getTagEnchantments().isEmpty() && !in.is(Items.ENCHANTED_BOOK)) {
            if (this.player != null) {
                if (!(this.player.containerMenu instanceof IndexMenu)) {
                    ItemStack c = in.copy();
                    this.getInputItemsHandler().setStackInSlot(0, ItemStack.EMPTY);
                    this.getOutputItemsHandler().setStackInSlot(0, c);
                    return false;
                }
            } else {
                ItemStack c = in.copy();
                this.getInputItemsHandler().setStackInSlot(0, ItemStack.EMPTY);
                this.getOutputItemsHandler().setStackInSlot(0, c);
                return false;
            }
        }
        return !in.getTagEnchantments().isEmpty() || in.getItem() == Items.ENCHANTED_BOOK;
    }

    public HashMap<Holder<Enchantment>, IndexEnchantData> getSaveEnchants() {
        return this.enchantData.getEnchantData();
    }

    public void handlePacket(CompoundTag msg) {
        if (this.getLevel() == null) {
            return;
        }
        ItemStack newItem = this.getInputItem().copy();
        if (!newItem.isEmpty() && (newItem.getEnchantments().isEmpty() || newItem.getItem() == Items.BOOK)) {
            if (!this.getOutputItem().isEmpty()) {
                return;
            }
            if (newItem.getItem() == Items.BOOK) {
                newItem = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            }
            Registry reg = this.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            ItemEnchantments.Mutable selectEnchants = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            ListTag datas = msg.getList("enchants", 10);
            int needMp = 0;
            IndexData newData = this.enchantData.copy();
            for (int i = 0; i < datas.size(); ++i) {
                int lvl;
                CompoundTag c = datas.getCompound(i);
                String id = c.getString("id");
                Optional enchantment = reg.getHolder(ResourceLocation.parse((String)id));
                if (!enchantment.isPresent() || !((Enchantment)((Holder.Reference)enchantment.get()).value()).canEnchant(newItem) && newItem.getItem() != Items.ENCHANTED_BOOK || (lvl = Math.min(c.getInt("lvl"), newData.getLvl((Holder<Enchantment>)((Holder)enchantment.get())))) <= 0 || !newData.dimEnchant((Holder<Enchantment>)((Holder)enchantment.get()), lvl)) continue;
                if (((ConfigData)Config.instance.getDatas()).indexMpUse > 0) {
                    needMp += lvl * ((ConfigData)Config.instance.getDatas()).indexMpUse;
                }
                selectEnchants.set((Holder)enchantment.get(), lvl);
                if (newItem.getItem() == Items.ENCHANTED_BOOK) {
                    newItem.set(DataComponents.STORED_ENCHANTMENTS, (Object)selectEnchants.toImmutable());
                    continue;
                }
                newItem.set(DataComponents.ENCHANTMENTS, (Object)selectEnchants.toImmutable());
            }
            if (needMp > this.mp) {
                return;
            }
            this.mp -= needMp;
            this.enchantData.replace(newData);
            ItemStack finalItem = newItem.copy();
            ItemStack input = this.getInputItem();
            input.shrink(1);
            this.getInputItemsHandler().setStackInSlot(0, input);
            this.getOutputItemsHandler().setStackInSlot(0, finalItem);
            this.updateToClient();
        }
    }

    private void updateToClient() {
        this.setChanged();
        if (this.getLevel() != null) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        if (this.player != null) {
            CompoundTag data = this.getNetPack();
            NetCore.sendToPlayer((NetPack.NetworkPack)NetPack.createClientPack((CompoundTag)data, (NetHandle)((NetHandle)NetRegister.INDEX_BLOCK.get())), (ServerPlayer)((ServerPlayer)this.player));
        }
    }

    public boolean shouldRenderFace(Direction pFace) {
        return Block.shouldRenderFace((BlockState)this.getBlockState(), (BlockGetter)this.getLevel(), (BlockPos)this.getBlockPos(), (Direction)pFace, (BlockPos)this.getBlockPos().relative(pFace));
    }
}

