/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.index.datatype;

import dev.anye.mc.cores.helper.enchantment.EnchantmentSupports;
import dev.anye.mc.index.datatype.IndexEnchantData;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class IndexData {
    public static final String ID = "id";
    public static final String MAX_LVL = "max";
    public static final String LVL = "lvl";
    public static final String XP = "xp";
    private Level level;
    private final HashMap<Holder<Enchantment>, IndexEnchantData> enchantData = new HashMap();

    private IndexData() {
    }

    public IndexData(Level level) {
        this();
        this.setLevel(level);
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public ListTag formatEnchants() {
        ListTag es = new ListTag();
        if (!this.enchantData.isEmpty()) {
            this.enchantData.forEach((eid, intInt) -> es.add((Object)intInt.toNBT()));
        }
        return es;
    }

    public void loadEnchants(HolderLookup.Provider registries, ListTag es) {
        Optional reg = registries.lookup(Registries.ENCHANTMENT);
        if (reg.isEmpty()) {
            return;
        }
        HolderLookup.RegistryLookup enchantHolderLookup = (HolderLookup.RegistryLookup)reg.get();
        for (int i = 0; i < es.size(); ++i) {
            CompoundTag compoundtag = es.getCompound(i);
            String eid = compoundtag.getString(ID);
            ResourceLocation loc = ResourceLocation.tryParse((String)eid);
            if (loc == null) continue;
            enchantHolderLookup.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)loc)).ifPresent(registryReference -> {
                Holder holder = registryReference.getDelegate();
                int lvl = Mth.clamp((int)compoundtag.getInt(MAX_LVL), (int)0, (int)Integer.MAX_VALUE);
                IndexEnchantData stringIntInt = new IndexEnchantData((Holder<Enchantment>)holder, lvl, compoundtag.getString(XP));
                this.enchantData.put((Holder<Enchantment>)holder, stringIntInt);
            });
        }
    }

    public void addEnchant(String eid, int pLvl) {
        ServerLifecycleHooks.getCurrentServer().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(ResourceLocation.parse((String)eid)).ifPresent(holder -> this.addEnchant((Holder<Enchantment>)holder, pLvl));
    }

    public void addEnchant(Holder<Enchantment> holder, int pLvl) {
        IndexEnchantData lEnchantData = this.enchantData.containsKey(holder) ? this.enchantData.get(holder) : new IndexEnchantData(holder);
        lEnchantData.addXp(this.lvlToXp(pLvl));
        lEnchantData.setMaxLvl(pLvl);
        this.enchantData.put(holder, lEnchantData);
    }

    public boolean dimEnchant(String eid, int pLvl) {
        boolean[] l = new boolean[]{false};
        ServerLifecycleHooks.getCurrentServer().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(ResourceLocation.parse((String)eid)).ifPresent(holder -> {
            l[0] = this.dimEnchant((Holder<Enchantment>)holder, pLvl);
        });
        return l[0];
    }

    public boolean dimEnchant(Holder<Enchantment> holder, int pLvl) {
        IndexEnchantData lEnchantData;
        if (this.enchantData.containsKey(holder) && (lEnchantData = this.enchantData.get(holder)).dimXp(this.lvlToXp(pLvl))) {
            this.enchantData.put(holder, lEnchantData);
            return true;
        }
        return false;
    }

    public void addToEnchantData(ItemStack item) {
        ItemEnchantments enchantments = EnchantmentSupports.getItemEnchantments((ItemStack)item);
        if (enchantments == null) {
            return;
        }
        enchantments.keySet().forEach(holder -> this.addEnchant((Holder<Enchantment>)holder, enchantments.getLevel(holder)));
    }

    private BigInteger lvlToXp(int lvl) {
        BigInteger base = new BigInteger("2");
        return base.pow(lvl - 1);
    }

    public HashMap<Holder<Enchantment>, IndexEnchantData> getEnchantData() {
        return this.enchantData;
    }

    public int getLvl(Holder<Enchantment> pEnchantment) {
        return this.enchantData.get(pEnchantment).getMaxLvl();
    }

    public BigInteger getXp(Enchantment pEnchantment) {
        return this.enchantData.get(pEnchantment).getXp();
    }

    public boolean dimXp(Enchantment pEnchantment, int pLvl) {
        BigInteger lXp = this.getXp(pEnchantment).subtract(this.lvlToXp(pLvl));
        if (lXp.compareTo(BigInteger.ZERO) < 0) {
            return false;
        }
        this.enchantData.get(pEnchantment).setXp(lXp);
        return true;
    }

    public String toString() {
        return "IndexData{level=" + String.valueOf(this.level) + ", enchantData=" + this.enchantData.toString() + "}";
    }

    public IndexData copy() {
        IndexData lIndexData = new IndexData(this.level);
        lIndexData.enchantData.putAll(this.enchantData);
        return lIndexData;
    }

    public void replace(IndexData pIndexData) {
        this.setLevel(pIndexData.getLevel());
        this.enchantData.putAll(pIndexData.getEnchantData());
    }
}

