/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.index.datatype;

import java.math.BigInteger;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.enchantment.Enchantment;

public class IndexEnchantData {
    private final Holder<Enchantment> enchant;
    private final String eid;
    private int maxLvl = 0;
    private BigInteger xp = BigInteger.ZERO;

    public IndexEnchantData(Holder<Enchantment> enchant) {
        this.enchant = enchant;
        this.eid = this.getHolderEnchant().getRegisteredName();
    }

    public IndexEnchantData(Holder<Enchantment> enchant, int maxLvl, BigInteger xp) {
        this(enchant);
        this.maxLvl = maxLvl;
        this.xp = xp;
    }

    public IndexEnchantData(Holder<Enchantment> enchant, int maxLvl, String xp) {
        this(enchant, maxLvl, new BigInteger(xp));
    }

    public Holder<Enchantment> getHolderEnchant() {
        return this.enchant;
    }

    public Enchantment getEnchant() {
        return (Enchantment)this.getHolderEnchant().value();
    }

    public String getEid() {
        return this.eid;
    }

    public void setMaxLvl(int newLvl) {
        this.maxLvl = Math.max(this.maxLvl, newLvl);
    }

    public int getMaxLvl() {
        return this.maxLvl;
    }

    public void setXp(String xp) {
        this.xp = new BigInteger(xp);
    }

    public void setXp(BigInteger xp) {
        this.xp = xp;
    }

    public void addMaxLvl(int na) {
        this.maxLvl += na;
    }

    public void addXp(BigInteger nb) {
        this.xp = this.xp.add(nb);
    }

    public boolean dimXp(BigInteger na) {
        if (this.xp.compareTo(na) < 0) {
            return false;
        }
        this.xp = this.xp.subtract(na);
        return true;
    }

    public BigInteger getXp() {
        return this.xp;
    }

    public CompoundTag toNBT() {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("id", this.getEid());
        compoundtag.putInt("max", this.getMaxLvl());
        compoundtag.putString("xp", this.getXp().toString());
        return compoundtag;
    }

    public String toString() {
        return "{eid:" + this.getEid() + "}{max:" + this.getMaxLvl() + "}{xp:" + this.getXp().toString() + "}";
    }
}

