/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.index.screen.index;

import dev.anye.mc.cores.helper.entity.EntityHelper;
import dev.anye.mc.index.block.index.IndexBlockEntity;
import dev.anye.mc.index.datatype.IndexEnchantData;
import dev.anye.mc.index.register.BlockRegister;
import dev.anye.mc.index.register.MenuTypeRegister;
import dev.anye.mc.index.screen.AbstractContainerMenuCore;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class IndexMenu
extends AbstractContainerMenuCore {
    private static final int invSlotX = 58;
    public final IndexBlockEntity index;
    private final Level level;
    private final ContainerData data;

    public IndexMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(windowId, playerInv, EntityHelper.getBlockEntity((LivingEntity)playerInv.player, (BlockPos)extraData.readBlockPos()), (ContainerData)new SimpleContainerData(6));
    }

    public IndexMenu(int cid, Inventory inv, BlockEntity ent, ContainerData dat) {
        super((MenuType)MenuTypeRegister.INDEX_MENU.get(), cid, 2);
        IItemHandler output;
        IndexMenu.checkContainerSize((Container)inv, (int)2);
        this.index = (IndexBlockEntity)ent;
        this.level = inv.player.level();
        this.data = dat;
        this.addPlayerInventory(inv, 143, 140, 18);
        this.addPlayerHotBar(inv, 143, 198, 18);
        IItemHandler input = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.index.getBlockPos(), this.index.getBlockState(), (BlockEntity)this.index, null);
        if (input != null) {
            this.addSlot((Slot)new SlotItemHandler(this, input, 0, 36, 141){

                public int getMaxStackSize(@NotNull ItemStack itemStack) {
                    if (itemStack.getItem() == Items.LAPIS_BLOCK || itemStack.getItem() == Items.LAPIS_LAZULI) {
                        return 64;
                    }
                    return 1;
                }
            });
        }
        if ((output = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.index.getBlockPos(), this.index.getBlockState(), (BlockEntity)this.index, (Object)Direction.DOWN)) != null) {
            this.addSlot((Slot)new SlotItemHandler(this, output, 0, 94, 141){

                public boolean mayPlace(@NotNull ItemStack stack) {
                    return false;
                }
            });
        }
        this.addDataSlots(dat);
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getProgress() {
        return this.data.get(0);
    }

    public int getProgressMax() {
        return this.data.get(1);
    }

    public int getScaleProgress() {
        int progress = this.data.get(0);
        int maxProgress = this.data.get(1);
        int progressSize = 28;
        return maxProgress != 0 && progress != 0 ? progress * progressSize / maxProgress : 0;
    }

    public int getX() {
        return this.data.get(2);
    }

    public int getY() {
        return this.data.get(3);
    }

    public int getZ() {
        return this.data.get(4);
    }

    public int getMP() {
        return this.data.get(5);
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return IndexMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.index.getBlockPos()), (Player)player, (Block)((Block)BlockRegister.INDEX.get()));
    }

    public HashMap<Holder<Enchantment>, IndexEnchantData> getEnchantData() {
        return this.index.getSaveEnchants();
    }

    public ItemStack getInputItem() {
        return this.index.getInputSlotItem(0);
    }
}

