/*
 * Decompiled with CFR 0.152.
 */
package dev.anye.mc.index.screen.index;

import dev.anye.mc.cores.helper.enchantment.EnchantmentSupports;
import dev.anye.mc.cores.screen.widget.DT_ListBoxData;
import dev.anye.mc.cores.screen.widget.simple.SimpleButton;
import dev.anye.mc.cores.screen.widget.simple.SimpleHotbar;
import dev.anye.mc.cores.screen.widget.simple.SimpleInventory;
import dev.anye.mc.cores.screen.widget.simple.SimpleLabel;
import dev.anye.mc.cores.screen.widget.simple.SimpleListBox;
import dev.anye.mc.cores.screen.widget.simple.SimpleProgressBar;
import dev.anye.mc.cores.screen.widget.simple.SimpleSlot;
import dev.anye.mc.index.datatype.IndexEnchantData;
import dev.anye.mc.index.register.NetRegister;
import dev.anye.mc.index.screen.index.IndexMenu;
import dev.anye.mc.net.core.NetCore;
import dev.anye.mc.net.core.NetHandle;
import dev.anye.mc.net.core.NetPack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class IndexScreen
extends AbstractContainerScreen<IndexMenu> {
    private int x;
    private int y;
    private HashMap<Holder<Enchantment>, IndexEnchantData> enchantData;
    private final HashMap<Holder<Enchantment>, Integer> selectEnchants = new HashMap();
    private int needMp = 0;
    private SimpleButton enchantItem;
    private SimpleListBox enchantments;
    private SimpleProgressBar progressBar;
    private SimpleLabel saveLabel;
    private SimpleLabel mpLabel;

    public IndexScreen(IndexMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.enchantData = ((IndexMenu)this.menu).getEnchantData();
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.imageHeight = 222;
        this.imageWidth = 311;
        this.leftPos = this.x = (this.width - this.imageWidth) / 2;
        this.topPos = this.y = (this.height - this.imageHeight) / 2;
        this.addEnchantItemButton();
        this.getEnchantments();
        this.addRenderableWidget((GuiEventListener)this.enchantments);
        this.addRenderableWidget((GuiEventListener)new SimpleSlot(this.x + 34, this.y + 139, 20, 20, (Component)Component.literal((String)"slot")));
        this.addRenderableWidget((GuiEventListener)new SimpleSlot(this.x + 92, this.y + 139, 20, 20, (Component)Component.literal((String)"slot")));
        this.addRenderableWidget((GuiEventListener)new SimpleInventory(this.x + 141, this.y + 138, (Component)Component.literal((String)"inventory")));
        this.addRenderableWidget((GuiEventListener)new SimpleHotbar(this.x + 141, this.y + 196, (Component)Component.literal((String)"hotbar")));
        this.progressBar = (SimpleProgressBar)new SimpleProgressBar(this.x + 60, this.y + 145, 26, 8, 0, 28, 0, (Component)Component.literal((String)"progressBar")).setLayerZ(1);
        this.addRenderableWidget((GuiEventListener)this.progressBar);
        this.saveLabel = (SimpleLabel)new SimpleLabel(this.x + 7, this.y + 200, 64, 16, (Component)Component.translatable((String)"tooltip.index.index.save.all").append("0"), true, false, true).setLayerZ(1);
        this.addRenderableWidget((GuiEventListener)this.saveLabel);
        this.mpLabel = (SimpleLabel)new SimpleLabel(this.saveLabel.getX() + this.saveLabel.getWidth() + 10, this.saveLabel.getY(), 64, 16, (Component)Component.translatable((String)"tooltip.index.index.mp").append(String.valueOf(((IndexMenu)this.menu).getMP())), true, false, true).setLayerZ(1);
        this.addRenderableWidget((GuiEventListener)this.mpLabel);
    }

    private void getEnchantments() {
        this.enchantments = (SimpleListBox)new SimpleListBox(this.x + 7, this.y + 17, 297, 108, 50, 16, (Component)Component.literal((String)"enchants"), this.getAllEnchantment()).setLayerZ(1);
    }

    private List<DT_ListBoxData> getAllEnchantment() {
        ArrayList<DT_ListBoxData> data = new ArrayList<DT_ListBoxData>();
        if (!this.enchantData.isEmpty()) {
            this.enchantData.forEach((holder, indexEnchantData) -> data.add(new DT_ListBoxData(EnchantmentSupports.getEnchantmentDescString(indexEnchantData.getHolderEnchant()), holder, List.of(EnchantmentSupports.getEnchantmentDescString(indexEnchantData.getHolderEnchant()), Component.translatable((String)("enchantment." + indexEnchantData.getHolderEnchant().getKey().location().toLanguageKey() + ".desc")), Component.translatable((String)"tooltip.index.index.max_lvl").append(String.valueOf(indexEnchantData.getMaxLvl())), Component.translatable((String)"tooltip.index.index.xp").append(indexEnchantData.getXp().toString())), this::addEnchantmentToSelect)));
        }
        return data;
    }

    private void addEnchantItemButton() {
        this.enchantItem = new SimpleButton(this.x + 34, this.y + 166, 79, 16, (Component)Component.translatable((String)"screen.index.index.button.enchant_item"), false, false, true, this::sendSelectEnchantPack);
        this.enchantItem.setLayerZ(1);
        this.addRenderableWidget((GuiEventListener)this.enchantItem);
    }

    private void sendSelectEnchantPack() {
        if (this.selectEnchants.isEmpty()) {
            return;
        }
        ListTag tags = new ListTag();
        this.selectEnchants.forEach((enchantment, integer) -> {
            CompoundTag ed = new CompoundTag();
            ed.putString("id", enchantment.getRegisteredName());
            ed.putInt("lvl", integer.intValue());
            tags.add((Object)ed);
        });
        CompoundTag lDat = new CompoundTag();
        lDat.put("enchants", (Tag)tags);
        lDat.putInt("be.x", ((IndexMenu)this.menu).getX());
        lDat.putInt("be.y", ((IndexMenu)this.menu).getY());
        lDat.putInt("be.z", ((IndexMenu)this.menu).getZ());
        NetCore.sendToServer((NetPack.NetworkPack)NetPack.createServerPack((CompoundTag)lDat, (NetHandle)((NetHandle)NetRegister.INDEX_BLOCK.get())));
    }

    public void addEnchantmentToSelect(Object v) {
        Holder enchantment;
        int lvl;
        Holder holder;
        if (v instanceof Holder && (holder = (Holder)v).value() instanceof Enchantment && (lvl = this.selectEnchants.getOrDefault(enchantment = (Holder)v, 0).intValue()) < this.enchantData.get(enchantment).getMaxLvl()) {
            this.selectEnchants.put(this.enchantData.get(enchantment).getHolderEnchant(), lvl + 1);
            this.needMp += 5;
        }
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.progressBar.setMaxProgress(((IndexMenu)this.menu).getProgressMax());
        this.progressBar.setProgress(((IndexMenu)this.menu).getProgress());
        this.mpLabel.setMessage((Component)Component.translatable((String)"tooltip.index.index.mp").append(String.valueOf(((IndexMenu)this.menu).getMP())));
        this.saveLabel.setMessage((Component)Component.translatable((String)"tooltip.index.index.save.all").append(String.valueOf(this.enchantData.size())));
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        this.updateSelectEnchantTooltip();
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        pGuiGraphics.fill(RenderType.endPortal(), 0, 0, this.width, this.height, -16777216);
    }

    private void updateSelectEnchantTooltip() {
        if (this.enchantItem != null) {
            ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
            tip.add(Component.translatable((String)"tooltip.index.index.select").append(String.valueOf(this.selectEnchants.size())));
            this.selectEnchants.forEach((enchantment, integer) -> tip.add((MutableComponent)Enchantment.getFullname((Holder)enchantment, (int)integer)));
            ChatFormatting color = ChatFormatting.GREEN;
            if (this.needMp > ((IndexMenu)this.menu).getMP()) {
                color = ChatFormatting.RED;
            }
            tip.add(Component.translatable((String)"tooltip.index.index.need_mp").append(String.valueOf(this.needMp)).withStyle(color));
            this.enchantItem.setCustomToolTip(tip);
        }
    }

    public void handlePacket(CompoundTag msg) {
        this.enchantData = new HashMap();
        ListTag es = msg.getList("index.enchants", 10);
        for (int i = 0; i < es.size(); ++i) {
            CompoundTag compoundtag = es.getCompound(i);
            if (Minecraft.getInstance().level == null) continue;
            EnchantmentSupports.getRegistry((Level)Minecraft.getInstance().level).getHolder(ResourceLocation.parse((String)compoundtag.getString("id"))).ifPresent(holder -> {
                IndexEnchantData indexEnchantData = new IndexEnchantData((Holder<Enchantment>)holder);
                int lvl = Mth.clamp((int)compoundtag.getInt("max"), (int)0, (int)Integer.MAX_VALUE);
                indexEnchantData.setXp(compoundtag.getString("xp"));
                indexEnchantData.setMaxLvl(lvl);
                this.enchantData.put((Holder<Enchantment>)holder, indexEnchantData);
            });
        }
        this.enchantments.setData(this.getAllEnchantment());
    }
}

