/*
 * Decompiled with CFR 0.152.
 */
package com.endlock;

import com.endlock.EndlockMod;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class EndlockState
extends class_18 {
    private boolean locked = false;
    private final List<PortalLocation> blockedPortals = new ArrayList<PortalLocation>();
    public static final Codec<EndlockState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("locked").forGetter(state -> state.locked), (App)PortalLocation.CODEC.listOf().fieldOf("blockedPortals").forGetter(state -> state.blockedPortals)).apply((Applicative)instance, (locked, portals) -> {
        EndlockState state = new EndlockState();
        state.locked = locked;
        state.blockedPortals.addAll((Collection<PortalLocation>)portals);
        return state;
    }));

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.method_80();
    }

    public boolean toggle() {
        this.locked = !this.locked;
        this.method_80();
        return this.locked;
    }

    public void addBlockedPortal(class_5321<class_1937> dimension, class_2338 pos) {
        PortalLocation location = new PortalLocation(dimension, pos);
        if (!this.blockedPortals.contains(location)) {
            this.blockedPortals.add(location);
            this.method_80();
            EndlockMod.LOGGER.info("Added blocked portal at {} in {}", (Object)pos, (Object)dimension.method_29177());
        }
    }

    public void removeBlockedPortal(class_5321<class_1937> dimension, class_2338 pos) {
        PortalLocation location = new PortalLocation(dimension, pos);
        if (this.blockedPortals.remove(location)) {
            this.method_80();
            EndlockMod.LOGGER.info("Removed portal at {} in {}", (Object)pos, (Object)dimension.method_29177());
        }
    }

    public List<PortalLocation> getBlockedPortals() {
        return new ArrayList<PortalLocation>(this.blockedPortals);
    }

    public void clearBlockedPortals() {
        this.blockedPortals.clear();
        this.method_80();
    }

    public class_2487 writeNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10556("locked", this.locked);
        class_2499 portalList = new class_2499();
        for (PortalLocation portal : this.blockedPortals) {
            class_2487 portalNbt = new class_2487();
            portalNbt.method_10582("dimension", portal.getDimension().method_29177().toString());
            portalNbt.method_10569("x", portal.getPos().method_10263());
            portalNbt.method_10569("y", portal.getPos().method_10264());
            portalNbt.method_10569("z", portal.getPos().method_10260());
            portalList.add((Object)portalNbt);
        }
        nbt.method_10566("blockedPortals", (class_2520)portalList);
        return nbt;
    }

    public static EndlockState fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        EndlockState state = new EndlockState();
        state.locked = nbt.method_10577("locked").orElse(false);
        if (nbt.method_10545("blockedPortals")) {
            nbt.method_10554("blockedPortals").ifPresent(portalList -> {
                for (int i = 0; i < portalList.size(); ++i) {
                    portalList.method_10602(i).ifPresent(portalNbt -> {
                        try {
                            portalNbt.method_10558("dimension").ifPresent(dimString -> {
                                class_2960 dimId = class_2960.method_12829((String)dimString);
                                if (dimId != null) {
                                    class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimId);
                                    int x = portalNbt.method_10550("x").orElse(0);
                                    int y = portalNbt.method_10550("y").orElse(0);
                                    int z = portalNbt.method_10550("z").orElse(0);
                                    class_2338 pos = new class_2338(x, y, z);
                                    state.blockedPortals.add(new PortalLocation((class_5321<class_1937>)dimension, pos));
                                }
                            });
                        }
                        catch (Exception e) {
                            EndlockMod.LOGGER.error("Failed to load portal location from NBT", (Throwable)e);
                        }
                    });
                }
            });
        }
        return state;
    }

    public static EndlockState getServerState(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) {
            EndlockMod.LOGGER.error("Failed to get overworld for persistent state!");
            return new EndlockState();
        }
        class_10741 type = new class_10741("endlock", EndlockState::new, CODEC, null);
        return (EndlockState)overworld.method_17983().method_17924(type);
    }

    public static class PortalLocation {
        private final class_5321<class_1937> dimension;
        private final class_2338 pos;
        public static final Codec<PortalLocation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1937.field_25178.fieldOf("dimension").forGetter(PortalLocation::getDimension), (App)class_2338.field_25064.fieldOf("pos").forGetter(PortalLocation::getPos)).apply((Applicative)instance, PortalLocation::new));

        public PortalLocation(class_5321<class_1937> dimension, class_2338 pos) {
            this.dimension = dimension;
            this.pos = pos;
        }

        public class_5321<class_1937> getDimension() {
            return this.dimension;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PortalLocation that = (PortalLocation)o;
            return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.pos, that.pos);
        }

        public int hashCode() {
            return Objects.hash(this.dimension, this.pos);
        }
    }
}

