/*
 * Decompiled with CFR 0.152.
 */
package com.endlock;

import com.endlock.EndlockMod;
import com.endlock.EndlockState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class PortalActivator {
    public static int activateBlockedPortals(MinecraftServer server, EndlockState state) {
        List<EndlockState.PortalLocation> portals = state.getBlockedPortals();
        ArrayList<EndlockState.PortalLocation> toRemove = new ArrayList<EndlockState.PortalLocation>();
        int activatedCount = 0;
        for (EndlockState.PortalLocation portal : portals) {
            class_3218 world = server.method_3847(portal.getDimension());
            if (world == null) {
                toRemove.add(portal);
                EndlockMod.LOGGER.warn("World {} not found for portal at {}", (Object)portal.getDimension().method_29177(), (Object)portal.getPos());
                continue;
            }
            class_2338 center = portal.getPos();
            if (PortalActivator.isPortalComplete((class_1937)world, center)) {
                if (!PortalActivator.hasPortalBlocks((class_1937)world, center)) {
                    PortalActivator.activatePortal((class_1937)world, center);
                    ++activatedCount;
                    EndlockMod.LOGGER.info("Activated portal at {} in {}", (Object)center, (Object)portal.getDimension().method_29177());
                }
                toRemove.add(portal);
                continue;
            }
            toRemove.add(portal);
            EndlockMod.LOGGER.info("Portal at {} in {} is no longer complete, removing from blocked list", (Object)center, (Object)portal.getDimension().method_29177());
        }
        for (EndlockState.PortalLocation portal : toRemove) {
            state.removeBlockedPortal(portal.getDimension(), portal.getPos());
        }
        return activatedCount;
    }

    private static boolean isPortalComplete(class_1937 world, class_2338 center) {
        class_2338[] framePositions;
        for (class_2338 pos : framePositions = PortalActivator.getFramePositions(center)) {
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() != class_2246.field_10398) {
                return false;
            }
            if (((Boolean)state.method_11654((class_2769)class_2333.field_10958)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean hasPortalBlocks(class_1937 world, class_2338 center) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 pos = center.method_10069(x, 0, z);
                if (world.method_8320(pos).method_26204() != class_2246.field_10027) continue;
                return true;
            }
        }
        return false;
    }

    private static void activatePortal(class_1937 world, class_2338 center) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 pos = center.method_10069(x, 0, z);
                world.method_8652(pos, class_2246.field_10027.method_9564(), 3);
            }
        }
    }

    private static class_2338[] getFramePositions(class_2338 center) {
        return new class_2338[]{center.method_10069(-1, 0, -2), center.method_10069(0, 0, -2), center.method_10069(1, 0, -2), center.method_10069(-1, 0, 2), center.method_10069(0, 0, 2), center.method_10069(1, 0, 2), center.method_10069(2, 0, -1), center.method_10069(2, 0, 0), center.method_10069(2, 0, 1), center.method_10069(-2, 0, -1), center.method_10069(-2, 0, 0), center.method_10069(-2, 0, 1)};
    }
}

