/*
 * Decompiled with CFR 0.152.
 */
package com.endlock;

import com.endlock.EndlockMod;
import com.endlock.EndlockState;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5321;

public class PortalTracker {
    public static void register() {
        UseBlockCallback.EVENT.register(PortalTracker::onUseBlock);
    }

    private static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() != class_2246.field_10398) {
            return class_1269.field_5811;
        }
        if (player.method_5998(hand).method_7909() != class_1802.field_8449) {
            return class_1269.field_5811;
        }
        if (((Boolean)state.method_11654((class_2769)class_2333.field_10958)).booleanValue()) {
            return class_1269.field_5811;
        }
        EndlockState endlockState = EndlockState.getServerState(world.method_8503());
        if (!endlockState.isLocked()) {
            return class_1269.field_5811;
        }
        class_2338 portalCenter = PortalTracker.findPortalCenter(world, pos);
        if (portalCenter == null) {
            return class_1269.field_5811;
        }
        if (PortalTracker.wouldCompletePortal(world, pos, portalCenter)) {
            endlockState.addBlockedPortal((class_5321<class_1937>)world.method_27983(), portalCenter);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"The End is locked. Complete this portal after unlocking The End.").method_27692(class_124.field_1065), false);
            }
            EndlockMod.LOGGER.info("Blocked portal completion at {} in {}", (Object)portalCenter, (Object)world.method_27983().method_29177());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static class_2338 findPortalCenter(class_1937 world, class_2338 framePos) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                class_2338 potentialCenter = framePos.method_10069(dx, 0, dz);
                if (!PortalTracker.isValidPortalCenter(world, potentialCenter)) continue;
                return potentialCenter;
            }
        }
        return null;
    }

    private static boolean isValidPortalCenter(class_1937 world, class_2338 center) {
        int z;
        class_2680 state;
        class_2338 pos;
        int x;
        for (x = -1; x <= 1; ++x) {
            pos = center.method_10069(x, 0, -2);
            state = world.method_8320(pos);
            if (state.method_26204() != class_2246.field_10398) {
                return false;
            }
            if (state.method_11654((class_2769)class_2333.field_10954) == class_2350.field_11035) continue;
            return false;
        }
        for (x = -1; x <= 1; ++x) {
            pos = center.method_10069(x, 0, 2);
            state = world.method_8320(pos);
            if (state.method_26204() != class_2246.field_10398) {
                return false;
            }
            if (state.method_11654((class_2769)class_2333.field_10954) == class_2350.field_11043) continue;
            return false;
        }
        for (z = -1; z <= 1; z += 2) {
            pos = center.method_10069(2, 0, z);
            state = world.method_8320(pos);
            if (state.method_26204() != class_2246.field_10398) {
                return false;
            }
            if (state.method_11654((class_2769)class_2333.field_10954) == class_2350.field_11039) continue;
            return false;
        }
        for (z = -1; z <= 1; z += 2) {
            pos = center.method_10069(-2, 0, z);
            state = world.method_8320(pos);
            if (state.method_26204() != class_2246.field_10398) {
                return false;
            }
            if (state.method_11654((class_2769)class_2333.field_10954) == class_2350.field_11034) continue;
            return false;
        }
        return true;
    }

    private static boolean wouldCompletePortal(class_1937 world, class_2338 eyePos, class_2338 center) {
        class_2338[] framePositions;
        int eyeCount = 0;
        for (class_2338 pos : framePositions = PortalTracker.getFramePositions(center)) {
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() != class_2246.field_10398) continue;
            if (pos.equals((Object)eyePos)) {
                ++eyeCount;
                continue;
            }
            if (!((Boolean)state.method_11654((class_2769)class_2333.field_10958)).booleanValue()) continue;
            ++eyeCount;
        }
        return eyeCount >= 12;
    }

    private static class_2338[] getFramePositions(class_2338 center) {
        return new class_2338[]{center.method_10069(-1, 0, -2), center.method_10069(0, 0, -2), center.method_10069(1, 0, -2), center.method_10069(-1, 0, 2), center.method_10069(0, 0, 2), center.method_10069(1, 0, 2), center.method_10069(2, 0, -1), center.method_10069(2, 0, 0), center.method_10069(2, 0, 1), center.method_10069(-2, 0, -1), center.method_10069(-2, 0, 0), center.method_10069(-2, 0, 1)};
    }
}

