/*
 * Decompiled with CFR 0.152.
 */
package net.redupro.dungeonsdimensionsn.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_4784;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.redupro.dungeonsdimensionsn.block.ModBlocks;
import net.redupro.dungeonsdimensionsn.block.custom.WartFluffBlock;
import net.redupro.dungeonsdimensionsn.world.gen.feature.ModifiedHugeFungusFeatureConfig;

public class ModifiedHugeFungusFeature
extends class_3031<ModifiedHugeFungusFeatureConfig> {
    private static final float field_31507 = 0.06f;

    public ModifiedHugeFungusFeature(Codec<ModifiedHugeFungusFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<ModifiedHugeFungusFeatureConfig> context) {
        class_5281 structureWorldAccess = context.method_33652();
        class_2338 blockPos = context.method_33655();
        class_5819 random = context.method_33654();
        class_2794 chunkGenerator = context.method_33653();
        ModifiedHugeFungusFeatureConfig modifiedHugeFungusFeatureConfig = (ModifiedHugeFungusFeatureConfig)context.method_33656();
        class_2248 block = modifiedHugeFungusFeatureConfig.validBaseBlock.method_26204();
        class_2338 blockPos2 = null;
        class_2680 blockState = structureWorldAccess.method_8320(blockPos.method_10074());
        if (blockState.method_27852(block)) {
            blockPos2 = blockPos;
        }
        if (blockPos2 == null) {
            return false;
        }
        int i = class_3532.method_15395((class_5819)random, (int)4, (int)13);
        if (random.method_43048(12) == 0) {
            i *= 2;
        }
        if (!modifiedHugeFungusFeatureConfig.planted) {
            int j = chunkGenerator.method_12104();
            if (blockPos2.method_10264() + i + 1 >= j) {
                return false;
            }
        }
        boolean bl = !modifiedHugeFungusFeatureConfig.planted && random.method_43057() < 0.06f;
        structureWorldAccess.method_8652(blockPos, class_2246.field_10124.method_9564(), 4);
        this.generateStem(structureWorldAccess, random, modifiedHugeFungusFeatureConfig, blockPos2, i, bl);
        this.generateHat(structureWorldAccess, random, modifiedHugeFungusFeatureConfig, blockPos2, i, bl);
        return true;
    }

    private static boolean isReplaceable(class_5281 world, class_2338 pos, ModifiedHugeFungusFeatureConfig config, boolean checkConfig) {
        if (world.method_16358(pos, class_4970.class_4971::method_45474)) {
            return true;
        }
        return checkConfig && config.replaceableBlocks.test((Object)world, (Object)pos);
    }

    private void generateStem(class_5281 world, class_5819 random, ModifiedHugeFungusFeatureConfig config, class_2338 pos, int stemHeight, boolean thickStem) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2680[] blockState = new class_2680[]{config.stemStateLayer1, config.stemStateLayer2, config.stemStateLayer3, config.stemState};
        int i = thickStem ? 1 : 0;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                boolean bl = thickStem && class_3532.method_15382((int)j) == i && class_3532.method_15382((int)k) == i;
                for (int l = 0; l < stemHeight; ++l) {
                    int m = Math.min(l, 3);
                    mutable.method_25504((class_2382)pos, j, l, k);
                    if (!ModifiedHugeFungusFeature.isReplaceable(world, (class_2338)mutable, config, true)) continue;
                    if (config.planted) {
                        if (!world.method_8320(mutable.method_10074()).method_26215()) {
                            world.method_22352((class_2338)mutable, true);
                        }
                        world.method_8652((class_2338)mutable, blockState[m], 3);
                        continue;
                    }
                    if (bl) {
                        if (!(random.method_43057() < 0.1f)) continue;
                        this.method_13153((class_1945)world, (class_2338)mutable, blockState[m]);
                        continue;
                    }
                    this.method_13153((class_1945)world, (class_2338)mutable, blockState[m]);
                }
            }
        }
    }

    private void generateHat(class_5281 world, class_5819 random, ModifiedHugeFungusFeatureConfig config, class_2338 pos, int hatHeight, boolean thickStem) {
        int j;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        boolean bl = config.hatState.method_27852(class_2246.field_10541);
        int i = Math.min(random.method_43048(1 + hatHeight / 3) + 5, hatHeight);
        for (int k = j = hatHeight - i; k <= hatHeight; ++k) {
            int l;
            int n = l = k < hatHeight - random.method_43048(3) ? 2 : 1;
            if (i > 8 && k < j + 4) {
                l = 3;
            }
            if (thickStem) {
                ++l;
            }
            for (int m = -l; m <= l; ++m) {
                for (int n2 = -l; n2 <= l; ++n2) {
                    boolean bl2 = m == -l || m == l;
                    boolean bl3 = n2 == -l || n2 == l;
                    boolean bl4 = !bl2 && !bl3 && k != hatHeight;
                    boolean bl5 = bl2 && bl3;
                    boolean bl6 = k < j + 3;
                    mutable.method_25504((class_2382)pos, m, k, n2);
                    if (!ModifiedHugeFungusFeature.isReplaceable(world, (class_2338)mutable, config, false)) continue;
                    if (config.planted && !world.method_8320(mutable.method_10074()).method_26215()) {
                        world.method_22352((class_2338)mutable, true);
                    }
                    if (bl6) {
                        if (bl4) continue;
                        this.placeWithOptionalVines((class_1936)world, random, (class_2338)mutable, config.hatState, bl);
                        continue;
                    }
                    if (bl4) {
                        this.placeHatBlock((class_1936)world, random, config, mutable, 0.1f, 0.2f, bl ? 0.1f : 0.0f);
                        continue;
                    }
                    if (bl5) {
                        this.placeHatBlock((class_1936)world, random, config, mutable, 0.01f, 0.7f, bl ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock((class_1936)world, random, config, mutable, 5.0E-4f, 0.98f, bl ? 0.07f : 0.0f);
                }
            }
        }
        this.generateFluff(world, random, config, pos, hatHeight, j);
    }

    private void placeHatBlock(class_1936 world, class_5819 random, ModifiedHugeFungusFeatureConfig config, class_2338.class_2339 pos, float decorationChance, float generationChance, float vineChance) {
        if (random.method_43057() < decorationChance) {
            this.method_13153((class_1945)world, (class_2338)pos, config.decorationState);
        } else if (random.method_43057() < generationChance) {
            this.method_13153((class_1945)world, (class_2338)pos, config.hatState);
            if (random.method_43057() < vineChance) {
                ModifiedHugeFungusFeature.generateVines((class_2338)pos, world, random);
            }
        }
    }

    private void generateFluff(class_5281 world, class_5819 random, ModifiedHugeFungusFeatureConfig config, class_2338 pos, int endHeight, int startHeight) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        boolean fl1 = config.hatState.method_27852(class_2246.field_22115);
        boolean fl2 = config.hatState.method_27852(class_2246.field_10541);
        class_2248 fluff = ModBlocks.WARPED_WART_FLUFF;
        float weight = 0.2f;
        if (fl1 || fl2) {
            if (fl2) {
                fluff = ModBlocks.NETHER_WART_FLUFF;
                weight = 0.1f;
            }
            for (int x = -3; x < 4; ++x) {
                for (int y = startHeight; y <= endHeight; ++y) {
                    for (int z = -3; z < 4; ++z) {
                        mutable.method_25504((class_2382)pos, x, y, z);
                        boolean bl = world.method_8320(mutable.method_10084()).method_27852(config.hatState.method_26204());
                        if (!(random.method_43057() < weight) || !world.method_8320((class_2338)mutable).method_27852(config.hatState.method_26204())) continue;
                        if (world.method_8320(mutable.method_10095()).method_26215() && world.method_8320(mutable.method_10095().method_10074()).method_26215() && z < 0) {
                            this.method_13153((class_1945)world, mutable.method_10095(), (class_2680)((class_2680)((class_2680)fluff.method_9564().method_11657(WartFluffBlock.FACING, (Comparable)class_2350.field_11035)).method_11657((class_2769)WartFluffBlock.HANGING, (Comparable)Boolean.valueOf(bl))).method_11657(WartFluffBlock.HALF, (Comparable)class_2756.field_12609));
                            this.method_13153((class_1945)world, mutable.method_10095().method_10074(), (class_2680)((class_2680)fluff.method_9564().method_11657(WartFluffBlock.FACING, (Comparable)class_2350.field_11035)).method_11657(WartFluffBlock.HALF, (Comparable)class_2756.field_12607));
                            continue;
                        }
                        if (world.method_8320(mutable.method_10078()).method_26215() && world.method_8320(mutable.method_10078().method_10074()).method_26215() && x > 0) {
                            this.method_13153((class_1945)world, mutable.method_10078(), (class_2680)((class_2680)((class_2680)fluff.method_9564().method_11657(WartFluffBlock.FACING, (Comparable)class_2350.field_11039)).method_11657((class_2769)WartFluffBlock.HANGING, (Comparable)Boolean.valueOf(bl))).method_11657(WartFluffBlock.HALF, (Comparable)class_2756.field_12609));
                            this.method_13153((class_1945)world, mutable.method_10078().method_10074(), (class_2680)((class_2680)fluff.method_9564().method_11657(WartFluffBlock.FACING, (Comparable)class_2350.field_11039)).method_11657(WartFluffBlock.HALF, (Comparable)class_2756.field_12607));
                            continue;
                        }
                        if (world.method_8320(mutable.method_10072()).method_26215() && world.method_8320(mutable.method_10072().method_10074()).method_26215() && z > 0) {
                            this.method_13153((class_1945)world, mutable.method_10072(), (class_2680)((class_2680)((class_2680)fluff.method_9564().method_11657(WartFluffBlock.FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WartFluffBlock.HANGING, (Comparable)Boolean.valueOf(bl))).method_11657(WartFluffBlock.HALF, (Comparable)class_2756.field_12609));
                            this.method_13153((class_1945)world, mutable.method_10072().method_10074(), (class_2680)((class_2680)fluff.method_9564().method_11657(WartFluffBlock.FACING, (Comparable)class_2350.field_11043)).method_11657(WartFluffBlock.HALF, (Comparable)class_2756.field_12607));
                            continue;
                        }
                        if (!world.method_8320(mutable.method_10067()).method_26215() || !world.method_8320(mutable.method_10067().method_10074()).method_26215() || x >= 0) continue;
                        this.method_13153((class_1945)world, mutable.method_10067(), (class_2680)((class_2680)((class_2680)fluff.method_9564().method_11657(WartFluffBlock.FACING, (Comparable)class_2350.field_11034)).method_11657((class_2769)WartFluffBlock.HANGING, (Comparable)Boolean.valueOf(bl))).method_11657(WartFluffBlock.HALF, (Comparable)class_2756.field_12609));
                        this.method_13153((class_1945)world, mutable.method_10067().method_10074(), (class_2680)((class_2680)fluff.method_9564().method_11657(WartFluffBlock.FACING, (Comparable)class_2350.field_11034)).method_11657(WartFluffBlock.HALF, (Comparable)class_2756.field_12607));
                    }
                }
            }
        }
    }

    private void placeWithOptionalVines(class_1936 world, class_5819 random, class_2338 pos, class_2680 state, boolean vines) {
        if (world.method_8320(pos.method_10074()).method_27852(state.method_26204())) {
            this.method_13153((class_1945)world, pos, state);
        } else if ((double)random.method_43057() < 0.15) {
            this.method_13153((class_1945)world, pos, state);
            if (vines && random.method_43048(11) == 0) {
                ModifiedHugeFungusFeature.generateVines(pos, world, random);
            }
        }
    }

    private static void generateVines(class_2338 pos, class_1936 world, class_5819 random) {
        class_2338.class_2339 mutable = pos.method_25503().method_10098(class_2350.field_11033);
        if (world.method_22347((class_2338)mutable)) {
            int i = class_3532.method_15395((class_5819)random, (int)1, (int)5);
            if (random.method_43048(7) == 0) {
                i *= 2;
            }
            int j = 23;
            int k = 25;
            class_4784.method_24450((class_1936)world, (class_5819)random, (class_2338.class_2339)mutable, (int)i, (int)23, (int)25);
        }
    }
}

