/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import kr.toxicity.model.api.BetterModel;
import meigo.dbettermodel.denizen.commands.BMBillboardCommand;
import meigo.dbettermodel.denizen.commands.BMLimbCommand;
import meigo.dbettermodel.denizen.commands.BMModelCommand;
import meigo.dbettermodel.denizen.commands.BMMountCommand;
import meigo.dbettermodel.denizen.commands.BMPartCommand;
import meigo.dbettermodel.denizen.commands.BMStateCommand;
import meigo.dbettermodel.denizen.events.BMReloadEndEvent;
import meigo.dbettermodel.denizen.events.BMReloadStartEvent;
import meigo.dbettermodel.denizen.objects.BMBoneTag;
import meigo.dbettermodel.denizen.objects.BMEntityTag;
import meigo.dbettermodel.denizen.objects.BMModelTag;
import meigo.dbettermodel.denizen.properties.DBetterModelEntityTagExtensions;
import meigo.dbettermodel.denizen.properties.DBetterModelPlayerTagExtensions;
import meigo.dbettermodel.services.ModelService;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.event.SkinApplyEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class DBetterModel
extends JavaPlugin {
    public static DBetterModel instance;
    public static final String BETTERMODEL_VERSION = "1.13.3";
    public static final String DBETTERMODEL_VERSION = "4.2.0";
    public static long skinApplyDelay;
    public static boolean enablePluginLogging;

    public void onEnable() {
        Debug.log((String)"DBetterModel 4.2.0 loading...");
        this.saveDefaultConfig();
        instance = this;
        this.reloadConfig();
        skinApplyDelay = this.getConfig().getLong("options.skin-apply-delay-ticks", 3L);
        ModelService.getInstance().initialize(this);
        Debug.log((String)"Targeting BetterModel API version 1.13.3");
        this.registerCommands();
        this.registerObjects();
        this.registerEvents();
        this.registerExtensions();
        this.registerSkinsRestorerListener();
        Debug.log((String)"DBetterModel loaded successfully!");
    }

    public static DBetterModel getInstance() {
        return instance;
    }

    private void registerSkinsRestorerListener() {
        if (this.getServer().getPluginManager().getPlugin("SkinsRestorer") == null) {
            Debug.log((String)"SkinsRestorer not found, listener will not be registered.");
            return;
        }
        try {
            SkinsRestorer skinsRestorerApi = SkinsRestorerProvider.get();
            skinsRestorerApi.getEventBus().subscribe((Object)this, SkinApplyEvent.class, event -> {
                Player player = (Player)event.getPlayer(Player.class);
                if (player == null) {
                    return;
                }
                GameProfile profile = BetterModel.plugin().nms().profile((OfflinePlayer)player);
                BetterModel.plugin().skinManager().removeCache(profile);
            });
            Debug.log((String)"Successfully hooked into SkinsRestorer event bus for SkinApplyEvent.");
        }
        catch (Throwable e) {
            Debug.echoError((String)"Error registering SkinsRestorer listener.");
            Debug.echoError((Throwable)e);
        }
    }

    private void registerCommands() {
        this.tryRegister("BMModelCommand", () -> DenizenCore.commandRegistry.registerCommand(BMModelCommand.class));
        this.tryRegister("BMStateCommand", () -> DenizenCore.commandRegistry.registerCommand(BMStateCommand.class));
        this.tryRegister("BMBillboardCommand", () -> DenizenCore.commandRegistry.registerCommand(BMBillboardCommand.class));
        this.tryRegister("BMLimbCommand", () -> DenizenCore.commandRegistry.registerCommand(BMLimbCommand.class));
        this.tryRegister("BMPartCommand", () -> DenizenCore.commandRegistry.registerCommand(BMPartCommand.class));
        this.tryRegister("BMMountCommand", () -> DenizenCore.commandRegistry.registerCommand(BMMountCommand.class));
    }

    private void registerObjects() {
        this.tryRegister("BMEntityTag", () -> ObjectFetcher.registerWithObjectFetcher(BMEntityTag.class, BMEntityTag.tagProcessor));
        this.tryRegister("BMModelTag", () -> ObjectFetcher.registerWithObjectFetcher(BMModelTag.class, BMModelTag.tagProcessor));
        this.tryRegister("BMBoneTag", () -> ObjectFetcher.registerWithObjectFetcher(BMBoneTag.class, BMBoneTag.tagProcessor));
    }

    private void registerEvents() {
        this.tryRegister("BMReloadStartEvent", () -> ScriptEvent.registerScriptEvent(BMReloadStartEvent.class));
        this.tryRegister("BMReloadEndEvent", () -> ScriptEvent.registerScriptEvent(BMReloadEndEvent.class));
    }

    private void registerExtensions() {
        this.tryRegister("DBetterModelEntityTagExtensions", DBetterModelEntityTagExtensions::register);
        this.tryRegister("DBetterModelPlayerTagExtensions", DBetterModelPlayerTagExtensions::register);
    }

    private void tryRegister(String featureName, Runnable registrationLogic) {
        try {
            registrationLogic.run();
        }
        catch (Throwable e) {
            Debug.echoError((String)("Error registering feature '" + featureName + "'."));
            Debug.echoError((Throwable)e);
        }
    }

    public void onDisable() {
        ModelService.getInstance().shutdown();
        Debug.log((String)"DBetterModel disabled.");
    }

    static {
        enablePluginLogging = true;
    }
}

