/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.commands;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import java.util.function.Predicate;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.util.function.BonePredicate;
import meigo.dbettermodel.util.DBMDebug;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;

public class BMBillboardCommand
extends AbstractCommand {
    public BMBillboardCommand() {
        this.setName("bmboard");
        this.setSyntax("bmboard entity:<entity> model:<model> bone:<bone> type:<fixed|vertical|horizontal|center>");
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entity") @ArgPrefixed EntityTag entityTag, @ArgName(value="model") @ArgPrefixed ElementTag modelName, @ArgName(value="bone") @ArgPrefixed ElementTag boneName, @ArgName(value="type") @ArgPrefixed ElementTag type) {
        Display.Billboard billboardType;
        Entity entity = entityTag.getBukkitEntity();
        try {
            billboardType = Display.Billboard.valueOf((String)type.asString().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            DBMDebug.error(scriptEntry, "Invalid billboard type specified: " + type.asString());
            return;
        }
        BetterModel.registry((Entity)entity).ifPresentOrElse(registry -> {
            EntityTracker tracker = registry.tracker(modelName.asString());
            if (tracker == null) {
                DBMDebug.error(scriptEntry, "Model '" + modelName.asString() + "' not found on entity.");
                return;
            }
            RenderedBone bone = tracker.bone(boneName.asString());
            if (bone == null) {
                DBMDebug.error(scriptEntry, "Bone '" + boneName.asString() + "' not found on model '" + modelName.asString() + "'.");
                return;
            }
            if (bone.billboard((Predicate)BonePredicate.TRUE, billboardType)) {
                tracker.forceUpdate(true);
                DBMDebug.approval(scriptEntry, "Set billboard type of bone '" + boneName.asString() + "' to '" + type.asString() + "'.");
            } else {
                DBMDebug.error(scriptEntry, "Failed to set billboard for bone '" + boneName.asString() + "'. It might be a dummy bone without a display.");
            }
        }, () -> DBMDebug.error(scriptEntry, "Entity does not have any models."));
    }
}

