/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.commands;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import java.util.HashSet;
import java.util.List;
import java.util.function.BooleanSupplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.util.function.BooleanConstantSupplier;
import meigo.dbettermodel.util.DBMDebug;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BMLimbCommand
extends AbstractCommand {
    public BMLimbCommand() {
        this.setName("bmlimb");
        this.setSyntax("bmlimb target:<player> model:<model_animator> animation:<animation_name> (loop:<once|loop|hold>) (hide:<player>)");
        this.autoCompile();
    }

    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("model:", BetterModel.limbs().stream().map(m -> m.name()).toList());
        tab.addWithPrefix("loop:", List.of("once", "loop", "hold"));
        if (tab.arg.toLowerCase().startsWith("animation:")) {
            HashSet allAnimations = new HashSet();
            BetterModel.limbs().forEach(model -> allAnimations.addAll(model.animations().keySet()));
            tab.add(allAnimations);
        }
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="target") @ArgPrefixed PlayerTag playerTag, @ArgName(value="model") @ArgPrefixed ElementTag modelName, @ArgName(value="animation") @ArgPrefixed ElementTag animationName, @ArgName(value="loop") @ArgDefaultText(value="once") @ArgPrefixed ElementTag loopMode, @ArgName(value="hide") @ArgPrefixed @ArgDefaultNull PlayerTag hideForPlayer) {
        Player player = playerTag.getPlayerEntity();
        if (player == null) {
            DBMDebug.error(scriptEntry, "Player not found.");
            return;
        }
        String model = modelName.asString();
        String animation = animationName.asString();
        if (BetterModel.limbOrNull((String)model) == null) {
            DBMDebug.error(scriptEntry, "Limb animator model '" + model + "' not found. Make sure it is configured under 'player-animations'.");
            return;
        }
        AnimationIterator.Type type = switch (loopMode.asString().toLowerCase().trim()) {
            case "loop" -> AnimationIterator.Type.LOOP;
            case "hold" -> AnimationIterator.Type.HOLD_ON_LAST;
            default -> AnimationIterator.Type.PLAY_ONCE;
        };
        AnimationModifier modifier = AnimationModifier.builder().predicate((BooleanSupplier)BooleanConstantSupplier.TRUE).start(0).end(0).type(type).speed(1.0f).build();
        boolean success = BetterModel.plugin().modelManager().animate(player, model, animation, modifier);
        if (success) {
            DBMDebug.approval(scriptEntry, "Started player animation '" + animation + "' from model '" + model + "' on " + player.getName() + " with mode '" + type.name().toLowerCase() + "'.");
        } else {
            DBMDebug.error(scriptEntry, "Failed to start animation '" + animation + "'. It might not exist in the model '" + model + "'.");
        }
        if (hideForPlayer != null) {
            Player observer = hideForPlayer.getPlayerEntity();
            if (observer == null) {
                DBMDebug.error(scriptEntry, "Observer player for 'hide' argument not found.");
            } else {
                BetterModel.registry((Entity)player).ifPresentOrElse(registry -> {
                    registry.trackers().forEach(tracker -> tracker.hide(observer));
                    DBMDebug.approval(scriptEntry, "Hid " + player.getName() + "'s models from " + observer.getName() + ".");
                }, () -> DBMDebug.error(scriptEntry, "Target player " + player.getName() + " has no models to hide."));
            }
        }
    }
}

