/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.commands;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import java.util.Optional;
import kr.toxicity.model.api.BetterModel;
import meigo.dbettermodel.util.DBMDebug;
import org.bukkit.entity.Entity;

public class BMModelCommand
extends AbstractCommand {
    public BMModelCommand() {
        this.setName("bmmodel");
        this.setSyntax("bmmodel entity:<entity> model:<model> (remove)");
        this.autoCompile();
    }

    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("model:", BetterModel.models().stream().map(m -> m.name()).toList());
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entity") @ArgPrefixed EntityTag entityTag, @ArgName(value="model") @ArgPrefixed ElementTag model, @ArgName(value="remove") boolean remove) {
        Entity entity = entityTag.getBukkitEntity();
        if (model == null) {
            DBMDebug.error(scriptEntry, "Model is not specified.");
            return;
        }
        String modelName = model.asString();
        if (remove) {
            BetterModel.registry((Entity)entity).ifPresentOrElse(registry -> {
                if (registry.remove(modelName)) {
                    DBMDebug.approval(scriptEntry, "Model '" + modelName + "' removed from entity.");
                } else {
                    DBMDebug.error(scriptEntry, "Model '" + modelName + "' not found on entity.");
                }
            }, () -> DBMDebug.error(scriptEntry, "Entity does not have any models."));
            return;
        }
        Optional.ofNullable(BetterModel.plugin().modelManager().renderer(modelName)).ifPresentOrElse(renderer -> {
            renderer.create(entity);
            DBMDebug.approval(scriptEntry, "Model '" + modelName + "' added to entity.");
        }, () -> DBMDebug.error(scriptEntry, "Model renderer '" + modelName + "' not found."));
    }
}

