/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.commands;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import java.util.Optional;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.nms.HitBox;
import meigo.dbettermodel.denizen.objects.BMBoneTag;
import meigo.dbettermodel.util.DBMDebug;
import org.bukkit.entity.Entity;

public class BMMountCommand
extends AbstractCommand {
    public BMMountCommand() {
        this.setName("bmmount");
        this.setSyntax("bmmount [<entity_to_mount>] on:<bmbone> (dismount) (dismount_all)");
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entity") @ArgDefaultNull @ArgLinear EntityTag entityToMount, @ArgName(value="on") @ArgPrefixed BMBoneTag onBone, @ArgName(value="dismount") boolean dismount, @ArgName(value="dismount_all") boolean dismountAll) {
        if (onBone == null) {
            DBMDebug.error(scriptEntry, "You must specify a bone to mount on or dismount from.");
            return;
        }
        RenderedBone bone = Optional.ofNullable(BetterModel.registryOrNull((UUID)onBone.getEntityUUID())).flatMap(registry -> Optional.ofNullable(registry.tracker(onBone.getModelName()))).flatMap(tracker -> Optional.ofNullable(tracker.bone(onBone.getBoneName()))).orElse(null);
        if (bone == null) {
            DBMDebug.error(scriptEntry, "The specified bone tag is invalid or the model is not loaded.");
            return;
        }
        HitBox hitBox = bone.getHitBox();
        if (hitBox == null) {
            DBMDebug.error(scriptEntry, "The bone '" + onBone.getBoneName() + "' is not a seat or does not have a hitbox. Make sure the bone is tagged with 'p' (e.g., 'p_seat').");
            return;
        }
        if (dismountAll) {
            hitBox.dismountAll();
            DBMDebug.approval(scriptEntry, "Dismounted all entities from bone '" + onBone.getBoneName() + "'.");
            return;
        }
        if (entityToMount == null) {
            DBMDebug.error(scriptEntry, "You must specify an entity to mount or dismount.");
            return;
        }
        Entity entity = entityToMount.getBukkitEntity();
        if (dismount) {
            hitBox.dismount(entity);
            DBMDebug.approval(scriptEntry, "Dismounted " + entity.getName() + " from bone '" + onBone.getBoneName() + "'.");
        } else {
            hitBox.mount(entity);
            DBMDebug.approval(scriptEntry, "Mounted " + entity.getName() + " on bone '" + onBone.getBoneName() + "'.");
        }
    }
}

