/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.commands;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Optional;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.manager.SkinManager;
import kr.toxicity.model.api.player.PlayerLimb;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.util.TransformedItemStack;
import meigo.dbettermodel.DBetterModel;
import meigo.dbettermodel.util.DBMDebug;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BMPartCommand
extends AbstractCommand {
    public BMPartCommand() {
        this.setName("bmpart");
        this.setSyntax("bmpart entity:<entity> model:<model> bone:<bone> part:<part_name> from:<player>");
        this.setRequiredArguments(5, 5);
        this.autoCompile();
    }

    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        if (tab.arg.startsWith("part:")) {
            tab.add(Arrays.stream(PlayerLimb.values()).map(limb -> limb.name().toLowerCase()).toList());
        }
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entity") @ArgPrefixed EntityTag entityTag, @ArgName(value="model") @ArgPrefixed ElementTag modelName, @ArgName(value="bone") @ArgPrefixed ElementTag boneName, @ArgName(value="part") @ArgPrefixed ElementTag partName, @ArgName(value="from") @ArgPrefixed PlayerTag fromPlayer) {
        Entity entity = entityTag.getBukkitEntity();
        Player sourcePlayer = fromPlayer.getPlayerEntity();
        if (entity == null || sourcePlayer == null) {
            DBMDebug.error(scriptEntry, "Target entity or source player not found.");
            return;
        }
        GameProfile sourceProfile = BetterModel.plugin().nms().profile((OfflinePlayer)sourcePlayer);
        final SkinManager skinManager = BetterModel.plugin().skinManager();
        skinManager.removeCache(sourceProfile);
        skinManager.getOrRequest(sourceProfile);
        Bukkit.getScheduler().runTaskLater((Plugin)DBetterModel.getInstance(), () -> {
            PlayerLimb targetLimb;
            Entity currentEntity = entityTag.getBukkitEntity();
            if (currentEntity == null) {
                return;
            }
            final Player currentPlayer = fromPlayer.getPlayerEntity();
            if (currentPlayer == null) {
                return;
            }
            Optional trackerOpt = BetterModel.registry((Entity)currentEntity).flatMap(registry -> Optional.ofNullable(registry.tracker(modelName.asString())));
            if (trackerOpt.isEmpty()) {
                DBMDebug.error(scriptEntry, "Model '" + modelName.asString() + "' not found on the entity after delay.");
                return;
            }
            EntityTracker tracker = (EntityTracker)trackerOpt.get();
            RenderedBone bone = tracker.bone(boneName.asString());
            if (bone == null || bone.getDisplay() == null) {
                DBMDebug.error(scriptEntry, "Bone '" + boneName.asString() + "' not found or is a dummy bone.");
                return;
            }
            try {
                targetLimb = PlayerLimb.valueOf((String)partName.asString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                DBMDebug.error(scriptEntry, "Invalid part name: '" + partName.asString() + "'.");
                return;
            }
            BoneItemMapper customMapper = new BoneItemMapper(){

                @NotNull
                public ItemDisplay.ItemDisplayTransform transform() {
                    return targetLimb.getItemMapper().transform();
                }

                @NotNull
                public TransformedItemStack apply(@NotNull RenderSource<?> renderSource, @NotNull TransformedItemStack originalItemStack) {
                    GameProfile currentProfile = BetterModel.plugin().nms().profile((OfflinePlayer)currentPlayer);
                    RenderSource.ProfiledDummy dummySource = new RenderSource.ProfiledDummy(currentPlayer.getLocation(), currentProfile, skinManager.isSlim(currentProfile));
                    return targetLimb.createItem((RenderSource.Profiled)dummySource);
                }
            };
            bone.setItemMapper(customMapper);
            bone.updateItem(b -> true);
            tracker.forceUpdate(true);
            DBMDebug.approval(scriptEntry, "Successfully applied skin part '" + partName.asString() + "' from " + fromPlayer.getName() + " to bone '" + boneName.asString() + "'.");
        }, DBetterModel.skinApplyDelay);
    }
}

