/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.commands;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import java.util.HashSet;
import java.util.function.Predicate;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.tracker.EntityTracker;
import meigo.dbettermodel.services.ModelService;
import meigo.dbettermodel.util.DBMDebug;
import org.bukkit.entity.Entity;

public class BMStateCommand
extends AbstractCommand {
    public BMStateCommand() {
        this.setName("bmstate");
        this.setSyntax("bmstate entity:<entity> model:<model> state:<animation> (bones:<list>) (loop:<once|loop|hold>) (speed:<#.#>) (lerp_duration:<duration>) (for_players:<list_of_players>) (remove)");
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entity") @ArgPrefixed EntityTag entityTag, @ArgName(value="model") @ArgPrefixed ElementTag modelName, @ArgName(value="state") @ArgPrefixed ElementTag animName, @ArgName(value="bones") @ArgPrefixed @ArgDefaultNull ListTag bones, @ArgName(value="loop") @ArgDefaultText(value="once") @ArgPrefixed ElementTag loopMode, @ArgName(value="speed") @ArgDefaultText(value="1.0") @ArgPrefixed ElementTag speedTag, @ArgName(value="lerp_duration") @ArgDefaultText(value="1t") @ArgPrefixed DurationTag lerpDuration, @ArgName(value="for_players") @ArgPrefixed @ArgDefaultNull ListTag forPlayers, @ArgName(value="remove") boolean remove) {
        Entity entity = entityTag.getBukkitEntity();
        BetterModel.registry((Entity)entity).ifPresentOrElse(registry -> {
            EntityTracker tracker = registry.tracker(modelName.asString());
            if (tracker == null) {
                DBMDebug.error(scriptEntry, "Model '" + modelName.asString() + "' not found on entity " + String.valueOf(entity.getUniqueId()) + ".");
                return;
            }
            String animation = animName.asString();
            Predicate<RenderedBone> boneFilter = bone -> true;
            if (bones != null) {
                HashSet boneNames = new HashSet(bones);
                boneFilter = bone -> boneNames.contains(bone.name().name());
            }
            if (remove) {
                if (tracker.stopAnimation(boneFilter, animation)) {
                    DBMDebug.approval(scriptEntry, "Stopped animation '" + animation + "' on model '" + modelName.asString() + "'.");
                } else {
                    DBMDebug.error(scriptEntry, "Animation '" + animation + "' was not running on the specified parts of model '" + modelName.asString() + "'.");
                }
                return;
            }
            AnimationIterator.Type type = switch (loopMode.asString().toLowerCase().trim()) {
                case "loop" -> AnimationIterator.Type.LOOP;
                case "hold" -> AnimationIterator.Type.HOLD_ON_LAST;
                default -> AnimationIterator.Type.PLAY_ONCE;
            };
            AnimationModifier.Builder builder = AnimationModifier.builder().start(lerpDuration.getTicksAsInt()).type(type).speed(() -> ((ElementTag)speedTag).asFloat()).override(Boolean.valueOf(false));
            ModelService.getInstance().playAnimationForPlayers(tracker, animation, builder.build(), forPlayers);
            DBMDebug.approval(scriptEntry, "Started animation '" + animation + "' on model '" + modelName.asString() + "'.");
        }, () -> DBMDebug.error(scriptEntry, "The entity does not have any BetterModel models attached."));
    }
}

