/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.objects;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import meigo.dbettermodel.denizen.objects.BMModelTag;
import meigo.dbettermodel.services.ModelService;
import org.bukkit.Location;
import org.joml.Vector3f;

public class BMBoneTag
implements ObjectTag,
Adjustable {
    public static final String PREFIX = "bmbone";
    private final UUID entityUUID;
    private final String modelName;
    private final String boneName;
    private String prefix = "bmbone";
    public static final ObjectTagProcessor<BMBoneTag> tagProcessor = new ObjectTagProcessor();

    public BMBoneTag(UUID entityUUID, String modelName, String boneName) {
        this.entityUUID = entityUUID;
        this.modelName = modelName;
        this.boneName = boneName;
    }

    @Fetchable(value="bmbone")
    public static BMBoneTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String lower = CoreUtilities.toLowerCase((String)string);
        if (!lower.startsWith("bmbone@")) {
            return null;
        }
        String body = string.substring(PREFIX.length() + 1);
        String[] parts = body.split(",", 3);
        if (parts.length < 3) {
            return null;
        }
        EntityTag entityTag = EntityTag.valueOf((String)parts[0], (TagContext)context);
        if (entityTag == null || entityTag.getBukkitEntity() == null) {
            return null;
        }
        return new BMBoneTag(entityTag.getUUID(), parts[1], parts[2]);
    }

    public static boolean matches(String arg) {
        return arg != null && CoreUtilities.toLowerCase((String)arg).startsWith("bmbone@");
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getBoneName() {
        return this.boneName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String s) {
        this.prefix = s;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "bmbone@" + String.valueOf(this.entityUUID) + "," + this.modelName + "," + this.boneName;
    }

    public String identifySimple() {
        return this.identify();
    }

    public Object getJavaObject() {
        return this;
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        tagProcessor.registerTag(ElementTag.class, "name", (attr, obj) -> new ElementTag(obj.boneName), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "world_location", (attr, obj) -> {
            Location loc = ModelService.getInstance().getBoneWorldLocation(obj.entityUUID, obj.modelName, obj.boneName);
            return loc != null ? new LocationTag(loc) : null;
        }, new String[0]);
        tagProcessor.registerTag(LocationTag.class, "world_rotation_euler", (attr, obj) -> {
            Vector3f euler = ModelService.getInstance().getBoneWorldRotationEuler(obj.entityUUID, obj.modelName, obj.boneName);
            return euler != null ? new LocationTag(null, (double)euler.x, (double)euler.y, (double)euler.z) : null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_visible", (attr, obj) -> new ElementTag(ModelService.getInstance().isBoneVisible(obj.entityUUID, obj.modelName, obj.boneName)), new String[0]);
        tagProcessor.registerTag(BMModelTag.class, "bm_model", (attr, obj) -> BetterModel.registry((UUID)obj.entityUUID).flatMap(registry -> Optional.ofNullable(registry.tracker(obj.modelName))).map(BMModelTag::new).orElse(null), new String[0]);
        tagProcessor.registerTag(MapTag.class, "global_position", (attr, obj) -> {
            Location globalLoc = ModelService.getInstance().getBoneWorldLocation(obj.entityUUID, obj.modelName, obj.boneName);
            if (globalLoc == null) {
                return null;
            }
            LocationTag globalPositionTag = new LocationTag(globalLoc);
            LocationTag localPositionTag = new LocationTag(globalLoc.getWorld(), 0.0, 0.0, 0.0);
            LinkedHashMap<StringHolder, LocationTag> positionMap = new LinkedHashMap<StringHolder, LocationTag>();
            positionMap.put(new StringHolder("global"), globalPositionTag);
            positionMap.put(new StringHolder("local"), localPositionTag);
            return new MapTag(positionMap);
        }, new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public void adjust(Mechanism mechanism) {
        ModelService.getInstance().adjustBone(this, mechanism);
    }

    public void applyProperty(Mechanism mechanism) {
        Debug.echoError((String)"Cannot apply properties to a BMBoneTag!");
    }
}

