/*
 * Decompiled with CFR 0.152.
 */
package meigo.dbettermodel.denizen.objects;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.tracker.EntityTracker;
import meigo.dbettermodel.denizen.objects.BMBoneTag;
import meigo.dbettermodel.denizen.objects.BMEntityTag;
import org.bukkit.entity.Entity;

public class BMModelTag
implements ObjectTag,
Adjustable {
    public static final String PREFIX = "bmmodel";
    private final EntityTracker tracker;
    private String prefix = "bmmodel";
    public static final ObjectTagProcessor<BMModelTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="bmmodel")
    public static BMModelTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String lower = CoreUtilities.toLowerCase((String)string);
        if (!lower.startsWith("bmmodel@")) {
            return null;
        }
        String body = string.substring(PREFIX.length() + 1);
        String[] parts = body.split(",", 2);
        if (parts.length < 2) {
            return null;
        }
        EntityTag entityTag = EntityTag.valueOf((String)parts[0], (TagContext)context);
        if (entityTag == null || entityTag.getBukkitEntity() == null) {
            return null;
        }
        return BetterModel.registry((Entity)entityTag.getBukkitEntity()).map(registry -> registry.tracker(parts[1])).map(BMModelTag::new).orElse(null);
    }

    public static boolean matches(String arg) {
        return arg != null && CoreUtilities.toLowerCase((String)arg).startsWith("bmmodel@");
    }

    public BMModelTag(EntityTracker tracker) {
        this.tracker = tracker;
    }

    public EntityTracker getTracker() {
        return this.tracker;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String s) {
        this.prefix = s;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "bmmodel@" + String.valueOf(this.tracker.registry().uuid()) + "," + this.tracker.name();
    }

    public String identifySimple() {
        return this.identify();
    }

    public Object getJavaObject() {
        return this.tracker;
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        tagProcessor.registerTag(BMEntityTag.class, "bm_entity", (attr, obj) -> new BMEntityTag(obj.getTracker().registry()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attr, obj) -> new ElementTag(obj.getTracker().name()), new String[0]);
        tagProcessor.registerTag(MapTag.class, "bones", (attr, obj) -> {
            MapTag map = new MapTag();
            UUID uuid = obj.getTracker().registry().uuid();
            String modelName = obj.getTracker().name();
            for (RenderedBone bone : obj.getTracker().bones()) {
                map.putObject(bone.name().name(), (ObjectTag)new BMBoneTag(uuid, modelName, bone.name().name()));
            }
            return map;
        }, new String[0]);
        tagProcessor.registerTag(BMBoneTag.class, "bone", (attr, obj) -> {
            if (!attr.hasContext(1)) {
                return null;
            }
            String boneName = attr.getContext(1);
            return Optional.ofNullable(obj.getTracker().bone(boneName)).map(bone -> new BMBoneTag(obj.getTracker().registry().uuid(), obj.getTracker().name(), bone.name().name())).orElse(null);
        }, new String[0]);
        tagProcessor.registerTag(DurationTag.class, "get_animation_duration", (attr, obj) -> {
            if (!attr.hasContext(1)) {
                attr.echoError("The get_animation_duration tag must have an animation name specified.");
                return null;
            }
            String animationName = attr.getContext(1);
            return obj.getTracker().renderer().animation(animationName).map(anim -> new DurationTag((double)anim.length())).orElse(null);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "animations", (attr, obj) -> {
            ModelRenderer renderer = obj.getTracker().getPipeline().getParent();
            if (renderer == null) {
                attr.echoError("Could not retrieve model renderer for " + obj.identify());
                return null;
            }
            Set animationNames = renderer.animations().keySet();
            return new ListTag(animationNames);
        }, new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("force_update") && (!mechanism.hasValue() || mechanism.requireBoolean())) {
            this.tracker.forceUpdate(true);
        }
        tagProcessor.processMechanism((ObjectTag)this, mechanism);
    }

    public void applyProperty(Mechanism mechanism) {
        Debug.echoError((String)"Cannot apply properties to a BMModelTag!");
    }
}

